/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.sp.impl;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.codec.Base64Support;
import net.shibboleth.shared.codec.DecodingException;
import net.shibboleth.shared.codec.EncodingException;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.sp.Agent;
import net.shibboleth.sp.Application;
import net.shibboleth.sp.profile.StateTokenManager;
import org.slf4j.Logger;

public class PassthroughStateTokenManager
extends AbstractIdentifiableInitializableComponent
implements StateTokenManager {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(PassthroughStateTokenManager.class);

    @Nonnull
    public String preserveToStateToken(@Nonnull Agent agent, @Nonnull Application application, @Nonnull byte[] value) throws IOException {
        try {
            return Base64Support.encodeURLSafe((byte[])value);
        }
        catch (EncodingException e) {
            throw new IOException(e);
        }
    }

    @Nullable
    public byte[] recoverFromStateToken(@Nonnull Agent agent, @Nonnull Application application, @Nonnull String token) throws IOException {
        try {
            return Base64Support.decodeURLSafe((String)token);
        }
        catch (DecodingException e) {
            this.log.warn("Unable to Base64-decode state token: {}", (Object)token);
            return null;
        }
    }
}

