/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.sp.impl;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.MoreObjects;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.filter.AttributeFilter;
import net.shibboleth.idp.attribute.resolver.AttributeResolver;
import net.shibboleth.idp.attribute.transcoding.AttributeTranscoderRegistry;
import net.shibboleth.profile.config.ProfileConfiguration;
import net.shibboleth.profile.relyingparty.BasicRelyingPartyConfiguration;
import net.shibboleth.profile.relyingparty.RelyingPartyConfiguration;
import net.shibboleth.profile.relyingparty.impl.DefaultRelyingPartyConfigurationResolver;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.ConstraintViolationException;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import net.shibboleth.shared.service.ReloadableService;
import net.shibboleth.sp.Agent;
import net.shibboleth.sp.Application;
import net.shibboleth.sp.profile.StateTokenManager;
import net.shibboleth.spring.security.CredentialHolder;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.security.config.SecurityConfiguration;
import org.opensaml.security.credential.Credential;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class BasicApplication
extends BasicRelyingPartyConfiguration
implements Application {
    @Nullable
    private Application parent;
    private boolean allowInheritance = true;
    @NonnullAfterInit
    private ApplicationAwareRelyingPartyResolver relyingPartyResolver = new ApplicationAwareRelyingPartyResolver();
    @Nonnull
    private Function<ProfileRequestContext, String> authenticatingAuthorityLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, List<String>> sessionInitiatorLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, List<String>> tokenConsumerLookupStrategy;
    @Nullable
    private StateTokenManager stateTokenManager;
    @Nullable
    private ReloadableService<MetadataResolver> metadataResolver;
    @Nullable
    private ReloadableService<AttributeTranscoderRegistry> transcodingRegistry;
    @Nullable
    private ReloadableService<AttributeResolver> attributeResolver;
    @Nullable
    private ReloadableService<AttributeFilter> attributeFilter;

    public BasicApplication() {
        this.relyingPartyResolver.setDefaultConfiguration((RelyingPartyConfiguration)this);
        this.authenticatingAuthorityLookupStrategy = FunctionSupport.constant(null);
        this.sessionInitiatorLookupStrategy = FunctionSupport.constant((Object)CollectionSupport.emptyList());
        this.tokenConsumerLookupStrategy = FunctionSupport.constant((Object)CollectionSupport.emptyList());
    }

    @Nonnull
    @NotEmpty
    public String getApplicationId() {
        return this.getId();
    }

    public boolean isAllowInheritance() {
        return this.allowInheritance;
    }

    public void setAllowInheritance(boolean flag) {
        this.checkSetterPreconditions();
        this.allowInheritance = flag;
    }

    @Nullable
    public Application getParent() {
        return this.parent;
    }

    public void setParent(@Nullable Application app) {
        this.parent = app;
    }

    @Nullable
    @NotEmpty
    public String getAuthenticatingAuthority(@Nullable ProfileRequestContext profileRequestContext) {
        String ret = this.authenticatingAuthorityLookupStrategy.apply(profileRequestContext);
        if (ret != null) {
            return ret;
        }
        if (this.parent != null && this.allowInheritance) {
            return this.parent.getAuthenticatingAuthority(profileRequestContext);
        }
        return null;
    }

    public void setAuthenticatingAuthority(@Nullable @NotEmpty String authority) {
        this.checkSetterPreconditions();
        this.authenticatingAuthorityLookupStrategy = FunctionSupport.constant((Object)StringSupport.trimOrNull((String)authority));
    }

    public void setAuthenticatingAuthorityLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.authenticatingAuthorityLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Authority lookup strategy cannot be null");
    }

    @Nonnull
    public List<String> getSessionInitiators(@Nullable ProfileRequestContext profileRequestContext) {
        List<String> ret = this.sessionInitiatorLookupStrategy.apply(profileRequestContext);
        if (ret != null && !ret.isEmpty()) {
            return ret;
        }
        if (this.parent != null && this.allowInheritance) {
            return this.parent.getSessionInitiators(profileRequestContext);
        }
        return CollectionSupport.emptyList();
    }

    public void setSessionInitiators(@Nullable Collection<String> initiators) {
        this.checkSetterPreconditions();
        this.sessionInitiatorLookupStrategy = initiators != null ? FunctionSupport.constant((Object)CollectionSupport.copyToList((Collection)StringSupport.normalizeStringCollection(initiators))) : FunctionSupport.constant((Object)CollectionSupport.emptyList());
    }

    public void setSessionInitiatorsLookupStrategy(@Nonnull Function<ProfileRequestContext, List<String>> strategy) {
        this.checkSetterPreconditions();
        this.sessionInitiatorLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Session initiators lookup strategy cannot be null");
    }

    @Nonnull
    public List<String> getTokenConsumers(@Nullable ProfileRequestContext profileRequestContext) {
        List<String> ret = this.tokenConsumerLookupStrategy.apply(profileRequestContext);
        if (ret != null && !ret.isEmpty()) {
            return ret;
        }
        if (this.parent != null && this.allowInheritance) {
            return this.parent.getTokenConsumers(profileRequestContext);
        }
        return CollectionSupport.emptyList();
    }

    public void setTokenConsumers(@Nullable Collection<String> consumers) {
        this.checkSetterPreconditions();
        this.tokenConsumerLookupStrategy = consumers != null ? FunctionSupport.constant((Object)CollectionSupport.copyToList((Collection)StringSupport.normalizeStringCollection(consumers))) : FunctionSupport.constant((Object)CollectionSupport.emptyList());
    }

    public void setTokenConsumersLookupStrategy(@Nonnull Function<ProfileRequestContext, List<String>> strategy) {
        this.checkSetterPreconditions();
        this.tokenConsumerLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Token consumers lookup strategy cannot be null");
    }

    @Nonnull
    public StateTokenManager getStateTokenManager() {
        this.checkComponentActive();
        if (this.stateTokenManager != null) {
            return this.stateTokenManager;
        }
        if (this.parent != null && this.allowInheritance) {
            return this.parent.getStateTokenManager();
        }
        throw new ConstraintViolationException("StateTokenManager cannot be null");
    }

    public void setStateTokenManager(@Nonnull StateTokenManager manager) {
        this.checkSetterPreconditions();
        this.stateTokenManager = (StateTokenManager)Constraint.isNotNull((Object)manager, (String)"StateTokenManager cannot be null");
    }

    @Nonnull
    public ReloadableService<MetadataResolver> getMetadataResolver() {
        this.checkComponentActive();
        if (this.metadataResolver != null) {
            return this.metadataResolver;
        }
        if (this.parent != null && this.allowInheritance) {
            return this.parent.getMetadataResolver();
        }
        throw new ConstraintViolationException("MetadataResolver cannot be null");
    }

    public void setMetadataResolver(@Nonnull ReloadableService<MetadataResolver> service) {
        this.checkSetterPreconditions();
        this.metadataResolver = (ReloadableService)Constraint.isNotNull(service, (String)"MetadataResolver service cannot be null");
    }

    @Nonnull
    public ReloadableService<AttributeTranscoderRegistry> getAttributeTranscoderRegistry() {
        this.checkComponentActive();
        if (this.transcodingRegistry != null) {
            return this.transcodingRegistry;
        }
        if (this.parent != null && this.allowInheritance) {
            return this.parent.getAttributeTranscoderRegistry();
        }
        throw new ConstraintViolationException("AttributeTranscoderRegistry cannot be null");
    }

    public void setAttributeTranscoderRegistry(@Nonnull ReloadableService<AttributeTranscoderRegistry> service) {
        this.checkSetterPreconditions();
        this.transcodingRegistry = (ReloadableService)Constraint.isNotNull(service, (String)"AttributeTranscoderRegistry service cannot be null");
    }

    @Nonnull
    public ReloadableService<AttributeResolver> getAttributeResolver() {
        this.checkComponentActive();
        if (this.attributeResolver != null) {
            return this.attributeResolver;
        }
        if (this.parent != null && this.allowInheritance) {
            return this.parent.getAttributeResolver();
        }
        throw new ConstraintViolationException("AttributeResolver cannot be null");
    }

    public void setAttributeResolver(@Nonnull ReloadableService<AttributeResolver> service) {
        this.checkSetterPreconditions();
        this.attributeResolver = (ReloadableService)Constraint.isNotNull(service, (String)"AttributeTranscoderRegistry service cannot be null");
    }

    @Nonnull
    public ReloadableService<AttributeFilter> getAttributeFilter() {
        this.checkComponentActive();
        if (this.attributeFilter != null) {
            return this.attributeFilter;
        }
        if (this.parent != null && this.allowInheritance) {
            return this.parent.getAttributeFilter();
        }
        throw new ConstraintViolationException("AttributeFilter cannot be null");
    }

    public void setAttributeFilter(@Nonnull ReloadableService<AttributeFilter> service) {
        this.checkSetterPreconditions();
        this.attributeFilter = (ReloadableService)Constraint.isNotNull(service, (String)"AttributeFilter service cannot be null");
    }

    @Nullable
    public String getIssuer(@Nullable ProfileRequestContext profileRequestContext) {
        Application application;
        String ret = super.getIssuer(profileRequestContext);
        if (ret != null) {
            return ret;
        }
        if (this.allowInheritance && (application = this.parent) instanceof BasicApplication) {
            BasicApplication basic = (BasicApplication)application;
            return basic.getIssuer(profileRequestContext);
        }
        return null;
    }

    @Nullable
    public SecurityConfiguration getSecurityConfiguration(@Nullable ProfileRequestContext profileRequestContext) {
        Application application;
        SecurityConfiguration ret = super.getSecurityConfiguration(profileRequestContext);
        if (ret != null) {
            return ret;
        }
        if (this.allowInheritance && (application = this.parent) instanceof BasicApplication) {
            BasicApplication basic = (BasicApplication)application;
            return basic.getSecurityConfiguration(profileRequestContext);
        }
        return null;
    }

    @Nonnull
    public Map<String, ProfileConfiguration> getProfileConfigurations(@Nullable ProfileRequestContext profileRequestContext) {
        Application application;
        Map ret = super.getProfileConfigurations(profileRequestContext);
        if (!ret.isEmpty()) {
            return ret;
        }
        if (this.allowInheritance && (application = this.parent) instanceof BasicApplication) {
            BasicApplication basic = (BasicApplication)application;
            return basic.getProfileConfigurations(profileRequestContext);
        }
        return CollectionSupport.emptyMap();
    }

    @Nullable
    public ProfileConfiguration getProfileConfiguration(@Nullable ProfileRequestContext profileRequestContext, @Nullable String profileId) {
        Application application;
        ProfileConfiguration ret = super.getProfileConfiguration(profileRequestContext, profileId);
        if (ret != null) {
            return ret;
        }
        if (this.allowInheritance && (application = this.parent) instanceof BasicApplication) {
            BasicApplication basic = (BasicApplication)application;
            return basic.getProfileConfiguration(profileRequestContext, profileId);
        }
        return null;
    }

    protected void doInitialize() throws ComponentInitializationException {
        this.relyingPartyResolver.setId(this.getApplicationId());
        this.relyingPartyResolver.initialize();
        super.doInitialize();
        if (this.allowInheritance) {
            return;
        }
        if (this.stateTokenManager == null) {
            throw new ComponentInitializationException("StateTokenManager cannot be null");
        }
        if (this.metadataResolver == null) {
            throw new ComponentInitializationException("MetadataResolver cannot be null");
        }
        if (this.transcodingRegistry == null) {
            throw new ComponentInitializationException("AttributeTranscoderRegistry cannot be null");
        }
        if (this.attributeResolver == null) {
            throw new ComponentInitializationException("AttributeResolver cannot be null");
        }
        if (this.attributeFilter == null) {
            throw new ComponentInitializationException("AttributeFilter cannot be null");
        }
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof Application)) return false;
        Application app = (Application)obj;
        if (!Objects.equals(this.getId(), app.getId())) return false;
        return true;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).toString();
    }

    @Nonnull
    public Collection<Credential> getSigningCredentials() {
        this.checkComponentActive();
        return this.relyingPartyResolver.getSigningCredentials();
    }

    @Nonnull
    public Collection<Credential> getEncryptionCredentials() {
        this.checkComponentActive();
        return this.relyingPartyResolver.getEncryptionCredentials();
    }

    @Nonnull
    public Iterable<RelyingPartyConfiguration> resolve(@Nullable CriteriaSet criteria) throws ResolverException {
        this.checkComponentActive();
        return this.relyingPartyResolver.resolve(criteria);
    }

    @Nullable
    public RelyingPartyConfiguration resolveSingle(@Nullable CriteriaSet criteria) throws ResolverException {
        this.checkComponentActive();
        return this.relyingPartyResolver.resolveSingle(criteria);
    }

    public void setRelyingPartyConfigurations(@Nullable Collection<? extends RelyingPartyConfiguration> configs) {
        this.checkSetterPreconditions();
        this.relyingPartyResolver.setRelyingPartyConfigurations(configs);
    }

    public void setDefaultConfiguration(@Nullable RelyingPartyConfiguration configuration) {
        this.checkSetterPreconditions();
        this.relyingPartyResolver.setDefaultConfiguration(configuration);
    }

    public void setUnverifiedConfiguration(@Nullable RelyingPartyConfiguration configuration) {
        this.checkSetterPreconditions();
        this.relyingPartyResolver.setUnverifiedConfiguration(configuration);
    }

    public void setMetricName(@Nullable String name) {
        this.checkSetterPreconditions();
        this.relyingPartyResolver.setMetricName(name);
    }

    @Autowired
    @Qualifier(value="signing")
    public void setSigningCredentials(@Nullable List<CredentialHolder> credentials) {
        this.checkSetterPreconditions();
        this.relyingPartyResolver.setSigningCredentials(credentials);
    }

    @Autowired
    @Qualifier(value="encryption")
    public void setEncryptionCredentials(@Nullable List<CredentialHolder> credentials) {
        this.checkSetterPreconditions();
        this.relyingPartyResolver.setEncryptionCredentials(credentials);
    }

    private class ApplicationAwareRelyingPartyResolver
    extends DefaultRelyingPartyConfigurationResolver {
        private ApplicationAwareRelyingPartyResolver() {
        }

        @Nullable
        public String getMetricName() {
            String base = super.getMetricName();
            if (base != null) {
                if (BasicApplication.this instanceof Agent) {
                    return MetricRegistry.name((String)base, (String[])new String[]{this.getId(), BasicApplication.this.getApplicationId()});
                }
                Application application = BasicApplication.this.parent;
                if (application instanceof Agent) {
                    Agent agent = (Agent)application;
                    return MetricRegistry.name((String)base, (String[])new String[]{agent.getId(), BasicApplication.this.getApplicationId()});
                }
                return MetricRegistry.name((String)base, (String[])new String[]{BasicApplication.this.getApplicationId()});
            }
            return null;
        }

        @Nonnull
        public Collection<? extends RelyingPartyConfiguration> getRelyingPartyConfigurations() {
            Application application;
            Collection ret = super.getRelyingPartyConfigurations();
            if (ret != null && !ret.isEmpty()) {
                return ret;
            }
            if (BasicApplication.this.allowInheritance && (application = BasicApplication.this.parent) instanceof BasicApplication) {
                BasicApplication basic = (BasicApplication)application;
                return basic.relyingPartyResolver.getRelyingPartyConfigurations();
            }
            return CollectionSupport.emptyList();
        }

        @Nullable
        public RelyingPartyConfiguration getDefaultConfiguration() {
            return BasicApplication.this;
        }

        @Nullable
        public RelyingPartyConfiguration getUnverifiedConfiguration() {
            Application application;
            RelyingPartyConfiguration ret = super.getUnverifiedConfiguration();
            if (ret != null) {
                return ret;
            }
            if (BasicApplication.this.allowInheritance && (application = BasicApplication.this.parent) instanceof BasicApplication) {
                BasicApplication basic = (BasicApplication)application;
                return basic.relyingPartyResolver.getUnverifiedConfiguration();
            }
            return null;
        }

        @Nonnull
        public Collection<Credential> getSigningCredentials() {
            Application application;
            Collection ret = super.getSigningCredentials();
            if (!ret.isEmpty()) {
                return ret;
            }
            if (BasicApplication.this.allowInheritance && (application = BasicApplication.this.parent) instanceof BasicApplication) {
                BasicApplication basic = (BasicApplication)application;
                return basic.getSigningCredentials();
            }
            return CollectionSupport.emptyList();
        }

        @Nonnull
        public Collection<Credential> getEncryptionCredentials() {
            Application application;
            Collection ret = super.getEncryptionCredentials();
            if (!ret.isEmpty()) {
                return ret;
            }
            if (BasicApplication.this.allowInheritance && (application = BasicApplication.this.parent) instanceof BasicApplication) {
                BasicApplication basic = (BasicApplication)application;
                return basic.getEncryptionCredentials();
            }
            return CollectionSupport.emptyList();
        }
    }
}

