/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.sp.authn.impl;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.time.Instant;
import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.servlet.HttpServletSupport;
import net.shibboleth.sp.Agent;
import net.shibboleth.sp.authn.impl.CachedAgentAuthentication;
import net.shibboleth.sp.profile.AbstractAgentAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class ValidateCachedAuthentication
extends AbstractAgentAction {
    @Nonnull
    @NotEmpty
    public static final String AGENT_SESSION_ATTRIBUTE = "net.shibboleth.sp.agent.cachedAuthentication";
    @Nonnull
    @NotEmpty
    public static final String BYPASS_AUTHENTICATION = "BypassAuthentication";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ValidateCachedAuthentication.class);

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        if (!this.ensureAgent().isSupportsCachedAuthentication()) {
            this.log.debug("{} Agent '{}' does not support cached authentication, skipping", (Object)this.getLogPrefix(), (Object)this.ensureAgent().getId());
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        HttpSession session;
        Agent agent = this.ensureAgent();
        HttpServletRequest request = this.getHttpServletRequest();
        HttpSession httpSession = session = request != null ? request.getSession(false) : null;
        if (session == null) {
            this.log.debug("{} No HttpSession associated with request from agent '{}', skipping cached authentication check", (Object)this.getLogPrefix(), (Object)agent.getId());
            return;
        }
        Object attr = session.getAttribute(AGENT_SESSION_ATTRIBUTE);
        if (attr instanceof CachedAgentAuthentication) {
            CachedAgentAuthentication cached = (CachedAgentAuthentication)attr;
            assert (request != null);
            if (cached.agentId().equals(agent.getId()) && cached.address().equals(HttpServletSupport.getRemoteAddr((ServletRequest)request)) && cached.expiration().isAfter(Instant.now())) {
                this.log.info("{} Accepted cached authentication session from agent '{}'", (Object)this.getLogPrefix(), (Object)agent.getId());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)BYPASS_AUTHENTICATION);
            } else {
                this.log.info("{} Rejected cached authentication session record from agent '{}': {}", new Object[]{this.getLogPrefix(), agent.getId(), cached});
                session.removeAttribute(AGENT_SESSION_ATTRIBUTE);
            }
        } else {
            this.log.debug("{} No session record for request from agent '{}', full authentication will proceed", (Object)this.getLogPrefix(), (Object)agent.getId());
        }
    }
}

