/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.sp.authn.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import net.shibboleth.idp.authn.AbstractUsernamePasswordCredentialValidator;
import net.shibboleth.idp.authn.CredentialValidator;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.UsernamePasswordContext;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.sp.Agent;
import net.shibboleth.sp.context.AgentRequestContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class AgentSecretCredentialValidator
extends AbstractUsernamePasswordCredentialValidator {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AgentSecretCredentialValidator.class);
    @Nonnull
    private Function<ProfileRequestContext, AgentRequestContext> agentRequestContextLookupStrategy = new ChildContextLookup(AgentRequestContext.class);
    @NonnullBeforeExec
    private Agent agent;

    public void setAgentRequestContextLookupStrategy(@Nonnull Function<ProfileRequestContext, AgentRequestContext> strategy) {
        this.checkSetterPreconditions();
        this.agentRequestContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AgentRequestContext lookup strategy cannot be null");
    }

    @Nullable
    protected Subject doValidate(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext, @Nonnull UsernamePasswordContext usernamePasswordContext, @Nullable CredentialValidator.WarningHandler warningHandler, @Nullable CredentialValidator.ErrorHandler errorHandler) throws Exception {
        Agent agent;
        AgentRequestContext agentContext = this.agentRequestContextLookupStrategy.apply(profileRequestContext);
        Agent agent2 = agent = agentContext != null ? agentContext.getAgent() : null;
        if (agent == null) {
            this.log.error("{} Agent missing from request context", (Object)this.getLogPrefix());
            LoginException e = new LoginException("InvalidProfileContext");
            if (errorHandler != null) {
                errorHandler.handleError(profileRequestContext, authenticationContext, (Exception)e, "InvalidProfileContext");
            }
            throw e;
        }
        if (agent.getSharedSecrets().isEmpty()) {
            this.log.debug("{} No shared secrets configured for agent '{}', ignoring", (Object)this.getLogPrefix(), (Object)agent.getId());
            return null;
        }
        this.log.debug("{} Attempting to authenticate agent '{}' ", (Object)this.getLogPrefix(), (Object)agent.getId());
        for (String candidate : agent.getSharedSecrets()) {
            if (!candidate.equals(usernamePasswordContext.getPassword())) continue;
            this.log.info("{} Authentication of agent '{}' succeeded", (Object)this.getLogPrefix(), (Object)agent.getId());
            return this.populateSubject(new Subject(), usernamePasswordContext);
        }
        this.log.info("{} Authentication of agent '{}' failed", (Object)this.getLogPrefix(), (Object)agent.getId());
        LoginException e = new LoginException("InvalidCredentials");
        if (errorHandler != null) {
            errorHandler.handleError(profileRequestContext, authenticationContext, (Exception)e, "InvalidCredentials");
        }
        throw e;
    }
}

