/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.plugin.storage.jdbc.impl;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TimerTask;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import net.shibboleth.plugin.storage.jdbc.impl.JDBCStorageRecord;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.Positive;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.ConstraintViolationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.storage.AbstractStorageService;
import org.opensaml.storage.EnumeratableStorageService;
import org.opensaml.storage.StorageCapabilities;
import org.opensaml.storage.StorageRecord;
import org.opensaml.storage.VersionMismatchException;
import org.slf4j.Logger;

public final class JDBCStorageService
extends AbstractStorageService
implements StorageCapabilities,
EnumeratableStorageService {
    static final String VERIFY_STRING = "net.shibboleth.plugin.storage.jdbc.impl.test";
    static final String DEFAULT_READ_CONTEXTS_SQL = "SELECT context FROM StorageRecords";
    static final String DEFAULT_READ_ALL_SQL = "SELECT context, id, expires, value, version FROM StorageRecords";
    static final String DEFAULT_READ_ALL_BY_CONTEXT_SQL = "SELECT id, expires, value, version FROM StorageRecords WHERE context=?";
    static final String DEFAULT_PRE_CREATE_QUERY_SQL = "SELECT expires FROM StorageRecords WHERE context=? AND id=?";
    static final String DEFAULT_CREATE_CREATE_RECORD_SQL = "INSERT INTO StorageRecords(context, id, expires, value, version) VALUES (?, ?, ?, ?, 1)";
    static final String DEFAULT_CREATE_UPDATE_RECORD_SQL = "UPDATE StorageRecords SET value=?, version=1, expires=? WHERE context=? AND id=?";
    static final String DEFAULT_READ_RECORD_SQL = "SELECT version, expires, value FROM StorageRecords WHERE context=? AND id=?";
    static final String DEFAULT_PRE_UPDATE_QUERY_SQL = "SELECT version, expires, value FROM StorageRecords WHERE context=? AND id=?";
    static final String DEFAULT_UPDATE_RECORD_SQL = "UPDATE StorageRecords SET value=?, version=?, expires=? WHERE context=? AND id=?";
    static final String DEFAULT_PRE_DELETE_QUERY_SQL = "SELECT version FROM StorageRecords WHERE context=? AND id=?";
    static final String DEFAULT_DELETE_RECORD_SQL = "DELETE FROM StorageRecords WHERE context=? AND id=?";
    static final String DEFAULT_DELETE_BY_EXPIRED_SQL = "DELETE FROM StorageRecords WHERE expires <= ? ";
    static final String DEFAULT_DELETE_BY_CONTEXT_EXPIRED_SQL = "DELETE FROM StorageRecords WHERE context = ? AND expires <= ?";
    static final String DEFAULT_UPDATE_EXPIRES_BY_CONTEXT_SQL = "UPDATE StorageRecords SET expires=? WHERE context = ? AND expires > ?";
    static final String DEFAULT_DELETE_BY_CONTEXT_SQL = "DELETE FROM StorageRecords WHERE context=?";
    static final String DEFAULT_GET_CONTEXT_KEYS_SQL = "SELECT id FROM StorageRecords WHERE context=? AND (expires IS NULL OR expires > ?)";
    static final String DEFAULT_GET_CONTEXT_KEYS_WITH_PREFIX_SQL = "SELECT id FROM StorageRecords WHERE context=? AND id like ? AND (expires IS NULL OR expires > ?)";
    static final Duration DEFAULT_QUERY_TIMEOUT = Duration.ofSeconds(5L);
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(JDBCStorageService.class);
    @Nonnull
    private Duration queryTimeout;
    private int transactionRetries = 3;
    private int transactionIsolation = 8;
    private ReadWriteLock readWriteLock;
    private boolean verify = true;
    @Nonnull
    @NonnullElements
    private Collection<String> retryableErrors = CollectionSupport.emptyList();
    @NonnullAfterInit
    private DataSource dataSource;
    @Nonnull
    @NotEmpty
    private String readContextsSQL = "SELECT context FROM StorageRecords";
    @Nonnull
    @NotEmpty
    private String readAllSQL = "SELECT context, id, expires, value, version FROM StorageRecords";
    @Nonnull
    @NotEmpty
    private String readAllByContextSQL = "SELECT id, expires, value, version FROM StorageRecords WHERE context=?";
    @Nonnull
    @NotEmpty
    private String preCreateQuerySQL = "SELECT expires FROM StorageRecords WHERE context=? AND id=?";
    @Nonnull
    @NotEmpty
    private String createCreateRecordSQL = "INSERT INTO StorageRecords(context, id, expires, value, version) VALUES (?, ?, ?, ?, 1)";
    @Nonnull
    @NotEmpty
    private String createUpdateRecordSQL = "UPDATE StorageRecords SET value=?, version=1, expires=? WHERE context=? AND id=?";
    @Nonnull
    @NotEmpty
    private String readRecordSQL = "SELECT version, expires, value FROM StorageRecords WHERE context=? AND id=?";
    @Nonnull
    @NotEmpty
    private String preUpdateQuerySQL = "SELECT version, expires, value FROM StorageRecords WHERE context=? AND id=?";
    @Nonnull
    @NotEmpty
    private String updateRecordSQL = "UPDATE StorageRecords SET value=?, version=?, expires=? WHERE context=? AND id=?";
    @Nonnull
    @NotEmpty
    private String preDeleteQuerySQL = "SELECT version FROM StorageRecords WHERE context=? AND id=?";
    @Nonnull
    @NotEmpty
    private String deleteRecordSQL = "DELETE FROM StorageRecords WHERE context=? AND id=?";
    @Nonnull
    @NotEmpty
    private String deleteByExpiredSQL = "DELETE FROM StorageRecords WHERE expires <= ? ";
    @Nonnull
    @NotEmpty
    private String deleteByContextExpiredSQL = "DELETE FROM StorageRecords WHERE context = ? AND expires <= ?";
    @Nonnull
    @NotEmpty
    private String updateExpiresByContextSQL = "UPDATE StorageRecords SET expires=? WHERE context = ? AND expires > ?";
    @Nonnull
    @NotEmpty
    private String deleteByContextSQL = "DELETE FROM StorageRecords WHERE context=?";
    @Nonnull
    @NotEmpty
    private String getContextKeysSQL = "SELECT id FROM StorageRecords WHERE context=? AND (expires IS NULL OR expires > ?)";
    @Nonnull
    @NotEmpty
    private String getContextKeysWithPrefixSQL = "SELECT id FROM StorageRecords WHERE context=? AND id like ? AND (expires IS NULL OR expires > ?)";

    public JDBCStorageService() {
        assert (DEFAULT_QUERY_TIMEOUT != null);
        this.queryTimeout = DEFAULT_QUERY_TIMEOUT;
        this.setContextSize(255);
        this.setKeySize(255);
        this.setValueSize(Integer.MAX_VALUE);
    }

    public void setTransactionRetries(@Positive int count) {
        this.transactionRetries = count;
        if (count < 0) {
            throw new ConstraintViolationException("transaction retry must be positive");
        }
    }

    public void setLocalLocking(boolean what) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.readWriteLock = what ? new ReentrantReadWriteLock(true) : null;
    }

    public void setVerify(boolean what) {
        this.verify = what;
    }

    public void setTransactionIsolation(int what) {
        this.transactionIsolation = what;
    }

    public void setDataSource(@Nonnull DataSource source) {
        this.dataSource = (DataSource)Constraint.isNotNull((Object)source, (String)"DataSource should be non null");
    }

    public void setRetryableErrors(@Nonnull @NonnullElements List<String> errors) {
        this.retryableErrors = CollectionSupport.copyToList((Collection)((Collection)Constraint.isNotNull(errors, (String)"errors must not be null")));
        Constraint.noNullItems(errors, (String)"errors must not have null members");
    }

    public void setReadContextsSQL(@Nonnull @NotEmpty String what) {
        this.readContextsSQL = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)what), (String)"Read Context SQL should be non-null and non empty");
    }

    public void setReadAllByContextSQL(@Nonnull @NotEmpty String what) {
        this.readAllByContextSQL = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)what), (String)"Read All By Context SQL should be non-null and non empty");
    }

    public void setReadAllSQL(@Nonnull @NotEmpty String what) {
        this.readAllSQL = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)what), (String)"Read All SQL should be non-null and non empty");
    }

    public void setPreCreateQuerySQL(@Nonnull @NotEmpty String what) {
        this.preCreateQuerySQL = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)what), (String)"PreCreateQuerySQL should be non-null and non empty");
    }

    public void setCreateCreateRecordSQL(@Nonnull @NotEmpty String what) {
        this.createCreateRecordSQL = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)what), (String)"CreateCreateRecordSQL should be non-null and non empty");
    }

    public void setCreateUpdateRecordSQL(@Nonnull @NotEmpty String what) {
        this.createUpdateRecordSQL = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)what), (String)"CreateUpdateRecordSQL should be non-null and non empty");
    }

    public void setReadRecordSQL(@Nonnull @NotEmpty String what) {
        this.readRecordSQL = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)what), (String)"ReadRecordSQL should be non-null and non empty");
    }

    public void setPreUpdateQuerySQL(@Nonnull @NotEmpty String what) {
        this.preUpdateQuerySQL = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)what), (String)"PreUpdateQuerySQL should be non-null and non empty");
    }

    public void setUpdateRecordSQL(@Nonnull @NotEmpty String what) {
        this.updateRecordSQL = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)what), (String)"UpdateRecordSQL should be non-null and non empty");
    }

    public void setPreDeleteQuerySQL(@Nonnull @NotEmpty String what) {
        this.preDeleteQuerySQL = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)what), (String)"PreDeleteSQL should be non-null and non empty");
    }

    public void setDeleteRecordSQL(String what) {
        this.deleteRecordSQL = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)what), (String)"DeleteRecordSQL should be non-null and non empty");
    }

    public void setDeleteByExpiredSQL(@Nonnull @NotEmpty String what) {
        this.deleteByExpiredSQL = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)what), (String)"DeleteByExpiredSQL should be non-null and non empty");
    }

    public void setDeleteByContextExpiredSQL(@Nonnull @NotEmpty String what) {
        this.deleteByContextExpiredSQL = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)what), (String)"DeleteByContextExpiredSQL should be non-null and non empty");
    }

    public void setUpdateExpiresByContextSQL(@Nonnull @NotEmpty String what) {
        this.updateExpiresByContextSQL = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)what), (String)"UpdateExpiresByContextSQL should be non-null and non empty");
    }

    public void setDeleteByContextSQL(@Nonnull @NotEmpty String what) {
        this.deleteByContextSQL = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)what), (String)"DeleteByContextSQL should be non-null and non empty");
    }

    public void setGetContextKeysSQL(@Nonnull @NotEmpty String what) {
        this.getContextKeysSQL = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)what), (String)"GetContextKeysSQL cannot be null or empty");
    }

    public void setQueryTimeout(@Nonnull Duration what) {
        this.queryTimeout = (Duration)Constraint.isNotNull((Object)what, (String)"QueryTimeout should be non null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        Constraint.isNotNull((Object)this.dataSource, (String)"data source must be specified and non-null");
        super.doInitialize();
        if (this.verify) {
            try {
                this.verifyDatabase();
            }
            catch (IOException | ComponentInitializationException e) {
                throw new ComponentInitializationException((Exception)e);
            }
        }
    }

    @Nonnull
    @NonnullElements
    protected List<String> readContexts() throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        ConnectionWithLock connection = new ConnectionWithLock(true, false);
        try {
            this.log.trace("ReadContexts:: ", (Object)this.readContextsSQL);
            try (PreparedStatement query = connection.prepareStatement(this.readContextsSQL);
                 ResultSet results = query.executeQuery();){
                while (results.next()) {
                    String context = results.getString(1);
                    this.log.trace("Context = '{}'", (Object)context);
                    result.add(context);
                }
            }
            ArrayList<String> arrayList = result;
            connection.close();
            return arrayList;
        }
        catch (Throwable throwable) {
            try {
                try {
                    connection.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SQLException e) {
                this.log.error("ReadContexts failed", (Throwable)e);
                throw new IOException(e);
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Nonnull
    @NonnullElements
    protected List<?> readAll() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    @NonnullElements
    protected List<?> readAll(@Nonnull @NotEmpty String context) throws IOException {
        ArrayList result = new ArrayList();
        Constraint.isNotEmpty((String)((String)Constraint.isNotNull((Object)context, (String)"ReadAll(String): context must not be null")), (String)"ReadAll(String): context must not be empty");
        try (ConnectionWithLock connection = new ConnectionWithLock(true, false);){
            ArrayList arrayList;
            block21: {
                PreparedStatement query = connection.prepareStatement(this.readAllByContextSQL);
                try {
                    this.log.trace("ReadAll:: '{}' 1: '{}'  ", (Object)this.readAllByContextSQL, (Object)context);
                    query.setString(1, context);
                    try (ResultSet results = query.executeQuery();){
                        while (results.next()) {
                            String id = results.getString(1);
                            Long expires = JDBCStorageService.getExpires(results, 2);
                            String value = (String)Constraint.isNotNull((Object)results.getString(3), (String)"value field must not be null");
                            Long version = results.getLong(4);
                            this.log.trace("Record: Id = '{}', value = '{}', verion = '{}', expires = '{}'", new Object[]{id, value, version, expires == null ? "<never>" : expires});
                            result.add(new JDBCStorageRecord(value, expires, version));
                        }
                    }
                    arrayList = result;
                    if (query == null) break block21;
                }
                catch (Throwable throwable) {
                    if (query != null) {
                        try {
                            query.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                query.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            this.log.error("ReadAll()", (Throwable)e);
            throw new IOException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean create(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nonnull @NotEmpty String value, @Nullable @Positive Long expiration) throws IOException {
        Constraint.isNotEmpty((String)((String)Constraint.isNotNull((Object)context, (String)"create: context must not be null")), (String)"create: context must not be empty");
        Constraint.isNotEmpty((String)((String)Constraint.isNotNull((Object)value, (String)"create: value must not be null")), (String)"create: value must not be empty");
        int retries = this.transactionRetries;
        while (true) {
            try (ConnectionWithLock connection = new ConnectionWithLock(false, true);){
                boolean bl;
                block36: {
                    block35: {
                        this.log.trace("Create [Query]:: '{}'::  1: '{}' ; 2: '{}'", new Object[]{this.preCreateQuerySQL, context, key});
                        PreparedStatement query = connection.prepareStatement(this.preCreateQuerySQL);
                        query.setString(1, context);
                        query.setString(2, key);
                        ResultSet resultSet = query.executeQuery();
                        if (!resultSet.next()) {
                            this.log.trace("Create [Insert]:: '{}'  1: '{}' ; 2: '{}' ; 3 '{}' ; 4 '{}'", new Object[]{this.createCreateRecordSQL, context, key, expiration, value});
                            PreparedStatement insert = connection.prepareStatement(this.createCreateRecordSQL);
                            insert.setString(1, context);
                            insert.setString(2, key);
                            JDBCStorageService.setExpires(insert, 3, expiration);
                            insert.setString(4, value);
                            insert.executeUpdate();
                            connection.commit();
                            boolean bl2 = true;
                            return bl2;
                        }
                        Long returnedExpiration = JDBCStorageService.getExpires(resultSet, 1);
                        if (returnedExpiration != null && System.currentTimeMillis() >= returnedExpiration) break block35;
                        this.log.debug("Duplicate record '{}' in context '{}'", (Object)key, (Object)context);
                        connection.rollback();
                        boolean bl3 = false;
                        return bl3;
                        {
                            finally {
                                if (resultSet != null) {
                                    resultSet.close();
                                }
                            }
                        }
                        finally {
                            if (query != null) {
                                query.close();
                            }
                        }
                    }
                    PreparedStatement update = connection.prepareStatement(this.createUpdateRecordSQL);
                    try {
                        this.log.trace("Create [Update]:: '{}'  1: '{}' ; 2: '{}' ; 3 '{}' ; 4 '{}'", new Object[]{this.createUpdateRecordSQL, value, expiration, context, key});
                        update.setString(1, value);
                        JDBCStorageService.setExpires(update, 2, expiration);
                        update.setString(3, context);
                        update.setString(4, key);
                        update.executeUpdate();
                        connection.commit();
                        bl = true;
                        if (update == null) break block36;
                    }
                    catch (Throwable throwable) {
                        if (update != null) {
                            try {
                                update.close();
                            }
                            catch (Throwable returnedExpiration) {
                                throwable.addSuppressed(returnedExpiration);
                            }
                        }
                        throw throwable;
                    }
                    update.close();
                }
                return bl;
            }
            catch (SQLException e) {
                boolean retry = false;
                for (String msg : this.retryableErrors) {
                    if (e.getSQLState() == null || !e.getSQLState().contains(msg)) continue;
                    this.log.warn("Caught retryable SQL exception", (Throwable)e);
                    retry = true;
                    break;
                }
                if (retry) {
                    if (--retries < 0) {
                        this.log.warn("Error retryable, but retry limit exceeded");
                        throw new IOException(e);
                    }
                    this.log.info("Retrying JDBC Create operation");
                    continue;
                }
                throw new IOException(e);
            }
            break;
        }
    }

    @Nullable
    public <T> StorageRecord<T> read(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key) throws IOException {
        return (StorageRecord)this.readImpl(context, key, null).getSecond();
    }

    @Nonnull
    public <T> Pair<Long, StorageRecord<T>> read(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Positive long version) throws IOException {
        return this.readImpl(context, key, version);
    }

    /*
     * Exception decompiling
     */
    @Nonnull
    protected <T> Pair<Long, StorageRecord<T>> readImpl(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nullable @Positive Long version) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 10 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean update(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nonnull @NotEmpty String value, @Nullable @Positive Long expiration) throws IOException {
        try {
            return this.updateImpl(null, context, key, value, expiration) != null;
        }
        catch (VersionMismatchException e) {
            throw new IllegalStateException("Unexpected exception thrown by update.", e);
        }
    }

    @Nullable
    public Long updateWithVersion(@Positive long version, @Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nonnull @NotEmpty String value, @Nullable @Positive Long expiration) throws IOException, VersionMismatchException {
        return this.updateImpl(version, context, key, value, expiration);
    }

    public boolean updateExpiration(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nullable @Positive Long expiration) throws IOException {
        try {
            return this.updateImpl(null, context, key, null, expiration) != null;
        }
        catch (VersionMismatchException e) {
            throw new IllegalStateException("Unexpected exception thrown by updateExpiration.", e);
        }
    }

    /*
     * Exception decompiling
     */
    @Nullable
    protected Long updateImpl(@Nullable Long version, @Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nullable String value, @Nullable @Positive Long expires) throws IOException, VersionMismatchException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean deleteWithVersion(@Positive long version, @Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key) throws IOException, VersionMismatchException {
        return this.deleteImpl(version, context, key);
    }

    public boolean delete(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key) throws IOException {
        try {
            return this.deleteImpl(null, context, key);
        }
        catch (VersionMismatchException e) {
            throw new IllegalStateException("Unexpected exception thrown by delete.", e);
        }
    }

    /*
     * Exception decompiling
     */
    protected boolean deleteImpl(@Nullable @Positive Long version, @Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key) throws IOException, VersionMismatchException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void deleteImpl(@Nonnull Long expiration) throws IOException {
        Constraint.isNotNull((Object)expiration, (String)"expiration: context must not be null");
        int retries = this.transactionRetries;
        while (true) {
            try (ConnectionWithLock connection = new ConnectionWithLock(false, true);){
                block17: {
                    PreparedStatement updateStmnt = connection.prepareStatement(this.deleteByExpiredSQL);
                    try {
                        updateStmnt.setLong(1, expiration);
                        this.log.trace("DeleteByExpired:: '{}':  1: '{}' ;", (Object)this.deleteByExpiredSQL, (Object)expiration);
                        updateStmnt.execute();
                        connection.commit();
                        if (updateStmnt == null) break block17;
                    }
                    catch (Throwable throwable) {
                        if (updateStmnt != null) {
                            try {
                                updateStmnt.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    updateStmnt.close();
                }
                return;
            }
            catch (SQLException e) {
                boolean retry = false;
                for (String msg : this.retryableErrors) {
                    if (e.getSQLState() == null || !e.getSQLState().contains(msg)) continue;
                    this.log.warn("Caught retryable SQL exception", (Throwable)e);
                    retry = true;
                    break;
                }
                if (retry) {
                    if (--retries < 0) {
                        this.log.warn("Error retryable, but retry limit exceeded");
                        throw new IOException(e);
                    }
                    this.log.info("Retrying JDBC DeletebyExpiration Operation");
                    continue;
                }
                throw new IOException(e);
            }
            break;
        }
    }

    public void reap(@Nonnull @NotEmpty String context) throws IOException {
        Constraint.isNotEmpty((String)((String)Constraint.isNotNull((Object)context, (String)"reap: context must not be null")), (String)"reap: context must not be empty");
        int retries = this.transactionRetries;
        while (true) {
            try (ConnectionWithLock connection = new ConnectionWithLock(true, true);){
                block17: {
                    PreparedStatement updateStmnt = connection.prepareStatement(this.deleteByContextExpiredSQL);
                    try {
                        updateStmnt.setString(1, context);
                        Long expires = System.currentTimeMillis();
                        JDBCStorageService.setExpires(updateStmnt, 2, expires);
                        this.log.trace("Reap:: '{}':  1: '{}' ; 2: '{}' ;", new Object[]{this.deleteByContextExpiredSQL, context, expires});
                        updateStmnt.execute();
                        if (updateStmnt == null) break block17;
                    }
                    catch (Throwable throwable) {
                        if (updateStmnt != null) {
                            try {
                                updateStmnt.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    updateStmnt.close();
                }
                return;
            }
            catch (SQLException e) {
                boolean retry = false;
                for (String msg : this.retryableErrors) {
                    if (e.getSQLState() == null || !e.getSQLState().contains(msg)) continue;
                    this.log.warn("Caught retryable SQL exception", (Throwable)e);
                    retry = true;
                    break;
                }
                if (retry) {
                    if (--retries < 0) {
                        this.log.warn("Error retryable, but retry limit exceeded");
                        throw new IOException(e);
                    }
                    this.log.info("Retrying JDBC DeleteByContext Operation");
                    continue;
                }
                throw new IOException(e);
            }
            break;
        }
    }

    public void updateContextExpiration(@Nonnull @NotEmpty String context, @Nullable Long expires) throws IOException {
        Constraint.isNotEmpty((String)((String)Constraint.isNotNull((Object)context, (String)"updateContextExpiration: context must not be null")), (String)"updateContextExpiration: context must not be empty");
        int retries = this.transactionRetries;
        while (true) {
            try (ConnectionWithLock connection = new ConnectionWithLock(true, true);){
                block18: {
                    PreparedStatement updateStmnt = connection.prepareStatement(this.updateExpiresByContextSQL);
                    try {
                        assert (updateStmnt != null);
                        JDBCStorageService.setExpires(updateStmnt, 1, expires);
                        updateStmnt.setString(2, context);
                        Long newExpires = System.currentTimeMillis();
                        JDBCStorageService.setExpires(updateStmnt, 3, newExpires);
                        this.log.trace("UpdateContextExpiration:: '{}':  1: '{}' ; 2: '{}' ; 3: '{}' ;", new Object[]{this.updateExpiresByContextSQL, expires, context, newExpires});
                        updateStmnt.execute();
                        if (updateStmnt == null) break block18;
                    }
                    catch (Throwable throwable) {
                        if (updateStmnt != null) {
                            try {
                                updateStmnt.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    updateStmnt.close();
                }
                return;
            }
            catch (SQLException e) {
                boolean retry = false;
                for (String msg : this.retryableErrors) {
                    if (e.getSQLState() == null || !e.getSQLState().contains(msg)) continue;
                    this.log.warn("Caught retryable SQL exception", (Throwable)e);
                    retry = true;
                    break;
                }
                if (retry) {
                    if (--retries < 0) {
                        this.log.warn("Error retryable, but retry limit exceeded");
                        throw new IOException(e);
                    }
                    this.log.info("Retrying JDBC DeleteByContext Operation");
                    continue;
                }
                throw new IOException(e);
            }
            break;
        }
    }

    public void deleteContext(@Nonnull @NotEmpty String context) throws IOException {
        Constraint.isNotEmpty((String)((String)Constraint.isNotNull((Object)context, (String)"deleteContext: context must not be null")), (String)"deleteContext: context must not be empty");
        int retries = this.transactionRetries;
        while (true) {
            try (ConnectionWithLock connection = new ConnectionWithLock(true, true);){
                block17: {
                    PreparedStatement updateStmnt = connection.prepareStatement(this.deleteByContextSQL);
                    try {
                        updateStmnt.setString(1, context);
                        this.log.trace("UpdateContextExpiration:: '{}': 1: '{}'", (Object)this.deleteByContextSQL, (Object)context);
                        updateStmnt.execute();
                        if (updateStmnt == null) break block17;
                    }
                    catch (Throwable throwable) {
                        if (updateStmnt != null) {
                            try {
                                updateStmnt.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    updateStmnt.close();
                }
                return;
            }
            catch (SQLException e) {
                boolean retry = false;
                for (String msg : this.retryableErrors) {
                    if (e.getSQLState() == null || !e.getSQLState().contains(msg)) continue;
                    this.log.warn("Caught retryable SQL exception", (Throwable)e);
                    retry = true;
                    break;
                }
                if (retry) {
                    if (--retries < 0) {
                        this.log.warn("Error retryable, but retry limit exceeded");
                        throw new IOException(e);
                    }
                    this.log.info("Retrying JDBC DeleteByContext Operation");
                    continue;
                }
                throw new IOException(e);
            }
            break;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public Iterable<String> getContextKeys(@Nonnull @NotEmpty String context, @Nullable String prefix) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        try (ConnectionWithLock connection = new ConnectionWithLock(true, false);){
            ArrayList<String> arrayList;
            block23: {
                PreparedStatement query = connection.prepareStatement(prefix != null ? this.getContextKeysWithPrefixSQL : this.getContextKeysSQL);
                try {
                    query.setString(1, context);
                    Long now = System.currentTimeMillis();
                    if (prefix != null) {
                        query.setString(2, prefix + "%");
                        JDBCStorageService.setExpires(query, 3, now);
                        this.log.trace("GetContextKeyWithPrefixs:: '{}': 1: '{}', 2: '{}', 3: '{}'", new Object[]{this.getContextKeysWithPrefixSQL, context, prefix, now});
                    } else {
                        JDBCStorageService.setExpires(query, 2, now);
                        this.log.trace("GetContextKeys:: '{}': 1: '{}', 2: '{}'", new Object[]{this.getContextKeysSQL, context, now});
                    }
                    try (ResultSet results = query.executeQuery();){
                        while (results.next()) {
                            String key = results.getString(1);
                            result.add(key);
                        }
                    }
                    arrayList = result;
                    if (query == null) break block23;
                }
                catch (Throwable throwable) {
                    if (query != null) {
                        try {
                            query.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                query.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            this.log.error("GetContextKeys failed", (Throwable)e);
            throw new IOException(e);
        }
    }

    private void verifyDatabase() throws IOException, ComponentInitializationException {
        this.create(VERIFY_STRING, VERIFY_STRING, VERIFY_STRING, System.currentTimeMillis() + 600000L);
        StorageRecord record = this.read(VERIFY_STRING, VERIFY_STRING);
        if (record == null) {
            throw new ComponentInitializationException("Insert into database failed");
        }
        if (!VERIFY_STRING.equals(record.getValue())) {
            throw new ComponentInitializationException("Value read back was incorrect");
        }
        String upper = VERIFY_STRING.toUpperCase();
        assert (upper != null);
        record = this.read(VERIFY_STRING, upper);
        if (record != null) {
            throw new ComponentInitializationException("Key Column is Case Insensitive");
        }
        record = this.read(upper, VERIFY_STRING);
        if (record != null) {
            throw new ComponentInitializationException("Context Column is Case Insensitive");
        }
        this.delete(VERIFY_STRING, VERIFY_STRING);
    }

    @Nullable
    private static Long getExpires(@Nonnull ResultSet results, int columm) throws SQLException {
        long value = results.getLong(columm);
        if (results.wasNull()) {
            return null;
        }
        return value;
    }

    private static void setExpires(@Nonnull PreparedStatement stmnt, int column, @Nullable Long expires) throws SQLException {
        if (expires == null) {
            stmnt.setNull(column, -5);
        } else {
            stmnt.setLong(column, expires);
        }
    }

    public boolean isServerSide() {
        return true;
    }

    public boolean isClustered() {
        return false;
    }

    @Nullable
    protected TimerTask getCleanupTask() {
        return new TimerTask(){

            @Override
            public void run() {
                Long now = System.currentTimeMillis();
                JDBCStorageService.this.log.debug("Running cleanup task at {}", (Object)now);
                try {
                    JDBCStorageService.this.deleteImpl(now);
                }
                catch (IOException e) {
                    JDBCStorageService.this.log.error("Error running cleanup task for {}", (Object)now, (Object)e);
                }
                JDBCStorageService.this.log.debug("Finished cleanup task for {}", (Object)now);
            }
        };
    }

    private class ConnectionWithLock
    implements AutoCloseable {
        @Nonnull
        private final Connection connection;
        @Nullable
        private final Lock threadLock;
        private final boolean isAutoCommit;
        private boolean isCommited;
        private boolean isRolledBack;

        public ConnectionWithLock(boolean autoCommit, boolean writeLock) throws SQLException {
            Connection con = JDBCStorageService.this.dataSource.getConnection();
            assert (con != null);
            this.connection = con;
            this.isAutoCommit = autoCommit;
            this.connection.setAutoCommit(autoCommit);
            if (JDBCStorageService.this.transactionIsolation > 0) {
                this.connection.setTransactionIsolation(JDBCStorageService.this.transactionIsolation);
            }
            if (JDBCStorageService.this.readWriteLock != null) {
                this.threadLock = writeLock ? JDBCStorageService.this.readWriteLock.writeLock() : JDBCStorageService.this.readWriteLock.readLock();
                assert (this.threadLock != null);
                this.threadLock.lock();
            } else {
                this.threadLock = null;
            }
        }

        public PreparedStatement prepareStatement(String sql) throws SQLException {
            PreparedStatement statement = this.connection.prepareStatement(sql);
            statement.setQueryTimeout((int)JDBCStorageService.this.queryTimeout.toSeconds());
            return statement;
        }

        public void commit() throws SQLException {
            assert (!(this.isAutoCommit || this.isCommited || this.isRolledBack));
            this.isCommited = true;
            this.connection.commit();
        }

        public void rollback() throws SQLException {
            assert (!(this.isAutoCommit || this.isCommited || this.isRolledBack));
            this.isRolledBack = true;
            this.connection.rollback();
        }

        @Override
        public void close() {
            assert (this.isAutoCommit || this.isCommited || this.isRolledBack);
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                JDBCStorageService.this.log.error("Auto close failed", (Throwable)e);
            }
            if (this.threadLock != null) {
                this.threadLock.unlock();
            }
        }
    }
}

