/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.core;

import com.nimbusds.jwt.JWT;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.openid.connect.sdk.Display;
import com.nimbusds.openid.connect.sdk.Nonce;
import com.nimbusds.openid.connect.sdk.OIDCClaimsRequest;
import com.nimbusds.openid.connect.sdk.Prompt;
import com.nimbusds.openid.connect.sdk.claims.ACR;
import com.nimbusds.openid.connect.sdk.claims.ClaimsSet;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.profile.core.OAuthAuthorizationRequest;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;

public class OIDCAuthenticationRequest
extends OAuthAuthorizationRequest {
    @Nonnull
    @NotEmpty
    private static final String DEFAULT_OPENID_SCOPE = "openid";
    @Nullable
    private JWT requestObject;
    @Nullable
    private ClaimsSet requestObjectClaimsSet;
    @Nullable
    private URI requestURI;
    @Nullable
    private OIDCClaimsRequest requestedClaims;
    private boolean providerSupportsClaimsParameter;
    @Nullable
    private String loginHint;
    @Nullable
    private Display display;
    @Nullable
    private Prompt prompt;
    @Nullable
    private Duration maxAge;
    @Nonnull
    @NotLive
    private List<ACR> acrs;
    @Nullable
    private Nonce nonce;
    @Nullable
    private Instant authnRequestTime;

    public OIDCAuthenticationRequest(@Nonnull ClientID id) {
        super(id);
        this.getScope().add(DEFAULT_OPENID_SCOPE);
        this.acrs = CollectionSupport.emptyList();
    }

    public void setRequestObjectClaimsSet(@Nullable ClaimsSet claims) {
        this.requestObjectClaimsSet = claims;
    }

    @Nullable
    public ClaimsSet getRequestObjectClaimsSet() {
        if (this.requestObject == null) {
            return this.requestObjectClaimsSet;
        }
        return null;
    }

    @Nullable
    public JWT getRequestObject() {
        return this.requestObject;
    }

    public void setRequestObject(@Nullable JWT object) {
        this.requestObject = object;
    }

    @Nullable
    public URI getRequestURI() {
        return this.requestURI;
    }

    public void setRequestURI(@Nullable URI uri) {
        this.requestURI = uri;
    }

    public void setRequestedClaims(@Nullable OIDCClaimsRequest claims) {
        this.requestedClaims = claims;
    }

    @Nullable
    public OIDCClaimsRequest getRequestedClaims() {
        return this.requestedClaims;
    }

    public boolean providerSupportsClaimsParameter() {
        return this.providerSupportsClaimsParameter;
    }

    public void setProviderSupportsClaimsParameter(boolean flag) {
        this.providerSupportsClaimsParameter = flag;
    }

    public void setLoginHint(@Nullable String hint) {
        this.loginHint = hint;
    }

    @Nullable
    public String getLoginHint() {
        return this.loginHint;
    }

    @Nullable
    public Display getDisplay() {
        return this.display;
    }

    public void setDisplay(@Nullable Display theDisplay) {
        this.display = theDisplay;
    }

    @Nullable
    public Prompt getPrompt() {
        return this.prompt;
    }

    public void setPrompt(@Nullable Prompt thePrompt) {
        this.prompt = thePrompt;
    }

    @Nullable
    public Duration getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(@Nullable Duration max) {
        this.maxAge = max;
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    public List<ACR> getAcrs() {
        return CollectionSupport.copyToList(this.acrs);
    }

    public void setAcrs(@Nullable List<ACR> theAcrs) {
        if (theAcrs != null) {
            this.acrs = CollectionSupport.copyToList(theAcrs);
        }
    }

    @Nullable
    public Nonce getNonce() {
        return this.nonce;
    }

    public void setNonce(@Nullable Nonce theNonce) {
        this.nonce = theNonce;
    }

    public void setAuthnRequestTime(@Nullable Instant time) {
        this.authnRequestTime = time;
    }

    @Nullable
    public Instant getAuthnRequestTime() {
        return this.authnRequestTime;
    }
}

