/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.core;

import com.nimbusds.oauth2.sdk.ResponseMode;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.State;
import java.net.URI;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;

public class OAuthAuthorizationRequest {
    @Nonnull
    private final ClientID clientID;
    @Nullable
    private State state;
    @Nullable
    private URI redirectURI;
    @Nullable
    private ResponseType responseType;
    @Nullable
    private URI endpointURI;
    @Nonnull
    private final Scope scope;
    @Nullable
    private ResponseMode responseMode;
    @Nullable
    private ResponseMode defaultResponseMode;
    @Nullable
    private String codeVerifier;
    @Nullable
    private String codeChallenge;
    @Nullable
    private CodeChallengeMethod codeChallengeMethod;

    public OAuthAuthorizationRequest(@Nonnull ClientID id) {
        this.clientID = (ClientID)Constraint.isNotNull((Object)id, (String)"ClientID can not be null");
        this.scope = new Scope();
    }

    public void setDefaultResponseMode(@Nullable ResponseMode mode) {
        this.defaultResponseMode = mode;
    }

    @Nullable
    public ResponseMode getDefaultResponseMode() {
        return this.defaultResponseMode;
    }

    @Nonnull
    public ClientID getClientID() {
        return this.clientID;
    }

    @Nullable
    public State getState() {
        return this.state;
    }

    public void setState(@Nullable State theState) {
        this.state = theState;
    }

    @Nullable
    public URI getRedirectURI() {
        return this.redirectURI;
    }

    public void setRedirectURI(@Nonnull URI uri) {
        this.redirectURI = (URI)Constraint.isNotNull((Object)uri, (String)"RedirectURI can not be null");
    }

    @Nullable
    public ResponseType getResponseType() {
        return this.responseType;
    }

    public void setResponseType(@Nonnull ResponseType type) {
        this.responseType = (ResponseType)Constraint.isNotNull((Object)type, (String)"ResponseType can not be null");
    }

    @Nullable
    public URI getEndpointURI() {
        return this.endpointURI;
    }

    public void setEndpointURI(@Nonnull URI uri) {
        this.endpointURI = (URI)Constraint.isNotNull((Object)uri, (String)"EndpointURI can not be null");
    }

    @Nonnull
    public Scope getScope() {
        return this.scope;
    }

    @Nullable
    public ResponseMode getResponseMode() {
        return this.responseMode;
    }

    public void setResponseMode(@Nullable ResponseMode mode) {
        this.responseMode = mode;
    }

    public void setCodeVerifier(@Nullable String code) {
        this.codeVerifier = code;
    }

    @Nullable
    public String getCodeVerifier() {
        return this.codeVerifier;
    }

    public void setCodeChallenge(@Nullable String code) {
        this.codeChallenge = code;
    }

    @Nullable
    public String getCodeChallenge() {
        return this.codeChallenge;
    }

    @Nullable
    public CodeChallengeMethod getCodeChallengeMethod() {
        return this.codeChallengeMethod;
    }

    public void setCodeChallengeMethod(@Nullable CodeChallengeMethod method) {
        this.codeChallengeMethod = method;
    }

    public static enum CodeChallengeMethod {
        PLAIN("plain"),
        S256("S256");

        @Nonnull
        @NotEmpty
        private final String value;

        private CodeChallengeMethod(String valueIn) {
            this.value = Constraint.isNotEmpty((String)valueIn, (String)"Code challenge method can not be null or empty");
        }

        @Nonnull
        @NotEmpty
        public String getValue() {
            return this.value;
        }
    }
}

