/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.config.navigate;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.RequestedPrincipalContext;
import net.shibboleth.oidc.authn.principal.AuthenticationContextClassReferencePrincipal;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.collection.CollectionSupport;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.context.ProfileRequestContext;

public class ProxyAwareDefaultOIDCAuthenticationContextClassRequestLookupFunction
implements Function<ProfileRequestContext, Collection<AuthenticationContextClassReferencePrincipal>> {
    @Nonnull
    @NonnullElements
    private Map<Principal, Collection<Principal>> principalMappings = CollectionSupport.emptyMap();

    public void setMappings(@Nullable @NonnullElements Map<Principal, Collection<Principal>> mappings) {
        if (mappings == null || mappings.isEmpty()) {
            this.principalMappings = CollectionSupport.emptyMap();
            return;
        }
        this.principalMappings = new HashMap<Principal, Collection<Principal>>(mappings.size());
        mappings.forEach((k, v) -> this.principalMappings.put((Principal)k, List.copyOf(v)));
    }

    @Override
    public Collection<AuthenticationContextClassReferencePrincipal> apply(ProfileRequestContext input) {
        AuthenticationContext ac;
        RequestedPrincipalContext rpc;
        BaseContext baseContext;
        if (input != null && (baseContext = input.getParent()) instanceof AuthenticationContext && (rpc = (RequestedPrincipalContext)(ac = (AuthenticationContext)baseContext).getSubcontext(RequestedPrincipalContext.class)) != null) {
            ArrayList<AuthenticationContextClassReferencePrincipal> mappedAndPassedThroughPrincipals = new ArrayList<AuthenticationContextClassReferencePrincipal>();
            for (Principal requestedPrincipal : rpc.getRequestedPrincipals()) {
                if (this.principalMappings.containsKey(requestedPrincipal)) {
                    Collection<Principal> mappedPrinicipals = this.principalMappings.get(requestedPrincipal);
                    for (Principal mappedPrincipal : mappedPrinicipals) {
                        if (!(mappedPrincipal instanceof AuthenticationContextClassReferencePrincipal)) continue;
                        mappedAndPassedThroughPrincipals.add((AuthenticationContextClassReferencePrincipal)((Object)mappedPrincipal));
                    }
                    continue;
                }
                String name = requestedPrincipal.getName();
                assert (name != null);
                mappedAndPassedThroughPrincipals.add(new AuthenticationContextClassReferencePrincipal(name));
            }
            return mappedAndPassedThroughPrincipals;
        }
        return CollectionSupport.emptyList();
    }
}

