/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.config.navigate;

import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public class ProviderMetadataStringValuesLookupFunction
implements Function<OIDCProviderMetadata, List<String>> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ProviderMetadataStringValuesLookupFunction.class);
    @Nonnull
    private final String keyName;

    public ProviderMetadataStringValuesLookupFunction(@ParameterName(name="keyName") @Nonnull String name) {
        this.keyName = Constraint.isNotEmpty((String)name, (String)"The key name cannot be empty");
    }

    @Override
    @Nullable
    public List<String> apply(@Nullable OIDCProviderMetadata metadata) {
        if (metadata == null) {
            this.log.trace("No provider metadata available");
            return CollectionSupport.emptyList();
        }
        Object value = metadata.toJSONObject().get((Object)this.keyName);
        if (value == null) {
            this.log.trace("No metadata value found for the key {}", (Object)this.keyName);
            return CollectionSupport.emptyList();
        }
        if (value instanceof String) {
            String s = (String)value;
            return CollectionSupport.singletonList((Object)s);
        }
        if (value instanceof List) {
            List valueList = (List)value;
            return valueList.stream().map(Object::toString).collect(Collectors.toList());
        }
        this.log.trace("Metadata provided an unknown type for key '{}'", (Object)this.keyName);
        return CollectionSupport.emptyList();
    }
}

