/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.config.navigate;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import net.shibboleth.oidc.profile.config.OIDCIDTokenProducingProfileConfiguration;
import net.shibboleth.profile.config.ProfileConfiguration;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.profile.context.navigate.AbstractRelyingPartyLookupFunction;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import org.opensaml.profile.context.ProfileRequestContext;

public class AudienceRestrictionsLookupFunction
extends AbstractRelyingPartyLookupFunction<Collection<String>> {
    @Nullable
    @NonnullElements
    @NotLive
    @Unmodifiable
    public Collection<String> apply(@Nullable ProfileRequestContext input) {
        RelyingPartyContext rpc = (RelyingPartyContext)this.getRelyingPartyContextLookupStrategy().apply(input);
        if (rpc != null) {
            String id = rpc.getRelyingPartyId();
            ProfileConfiguration pc = rpc.getProfileConfig();
            if (pc instanceof OIDCIDTokenProducingProfileConfiguration && !((OIDCIDTokenProducingProfileConfiguration)pc).getAdditionalAudiencesForIdToken(input).isEmpty()) {
                ImmutableList.Builder builder = ImmutableList.builder();
                if (id != null) {
                    builder.add((Object)rpc.getRelyingPartyId());
                }
                builder.addAll(((OIDCIDTokenProducingProfileConfiguration)pc).getAdditionalAudiencesForIdToken(input));
                return builder.build();
            }
            if (id != null) {
                return Collections.singletonList(rpc.getRelyingPartyId());
            }
        }
        return Collections.emptyList();
    }
}

