/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.config;

import java.time.Duration;
import java.util.Map;
import javax.annotation.Nullable;
import net.shibboleth.oidc.metadata.policy.MetadataPolicy;
import net.shibboleth.oidc.profile.config.OIDCFlowAwareProfileConfiguration;
import net.shibboleth.oidc.profile.oauth2.config.OAuth2ClientAuthenticableProfileConfiguration;
import net.shibboleth.profile.config.OverriddenIssuerProfileConfiguration;
import net.shibboleth.shared.annotation.ConfigurationSetting;
import net.shibboleth.shared.annotation.constraint.NonNegative;
import org.opensaml.profile.context.ProfileRequestContext;

public interface OIDCDynamicRegistrationConfiguration
extends OverriddenIssuerProfileConfiguration,
OIDCFlowAwareProfileConfiguration,
OAuth2ClientAuthenticableProfileConfiguration {
    public static final String PROTOCOL_URI = "https://openid.net/specs/openid-connect-registration-1_0.html";
    public static final String PROFILE_ID = "http://shibboleth.net/ns/profiles/oidc/registration";

    @ConfigurationSetting(name="registrationValidityPeriod")
    @Nullable
    @NonNegative
    public Duration getRegistrationValidityPeriod(@Nullable ProfileRequestContext var1);

    @ConfigurationSetting(name="secretExpirationPeriod")
    @Nullable
    @NonNegative
    public Duration getSecretExpirationPeriod(@Nullable ProfileRequestContext var1);

    @ConfigurationSetting(name="metadataPolicy")
    @Nullable
    public Map<String, MetadataPolicy> getMetadataPolicy(@Nullable ProfileRequestContext var1);
}

