/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.config;

import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.config.AuthenticationProfileConfiguration;
import net.shibboleth.oidc.profile.config.OIDCAuthenticationProfileConfiguration;
import net.shibboleth.oidc.profile.config.OIDCSSOProviderConfiguration;
import net.shibboleth.oidc.profile.oauth2.config.OAuth2AuthorizationCodeProducingProfileConfiguration;
import net.shibboleth.profile.config.OverriddenIssuerProfileConfiguration;
import net.shibboleth.shared.annotation.ConfigurationSetting;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import org.opensaml.profile.context.ProfileRequestContext;

public interface OIDCAuthorizationConfiguration
extends OIDCAuthenticationProfileConfiguration,
OAuth2AuthorizationCodeProducingProfileConfiguration,
AuthenticationProfileConfiguration,
OverriddenIssuerProfileConfiguration,
OIDCSSOProviderConfiguration {
    @Nonnull
    @NotEmpty
    public static final String PROFILE_ID = "http://shibboleth.net/ns/profiles/oidc/sso/browser";
    public static final int FEATURE_ESSENTIAL_ACR_REQUEST = 1;

    @ConfigurationSetting(name="acrRequestAlwaysEssential")
    public boolean isAcrRequestAlwaysEssential(@Nullable ProfileRequestContext var1);

    @ConfigurationSetting(name="encodeConsentInTokens")
    public boolean isEncodeConsentInTokens(@Nullable ProfileRequestContext var1);

    @ConfigurationSetting(name="deniedUserInfoAttributes")
    @Nonnull
    @NonnullElements
    @NotLive
    public Set<String> getDeniedUserInfoAttributes(@Nullable ProfileRequestContext var1);

    @ConfigurationSetting(name="includeIssuerInResponse")
    public boolean isIncludeIssuerInResponse(@Nullable ProfileRequestContext var1);

    @ConfigurationSetting(name="encodedAttributes")
    @Nonnull
    @NonnullElements
    @NotLive
    public Set<String> getEncodedAttributes(@Nullable ProfileRequestContext var1);
}

