/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.config;

import java.time.Duration;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.security.jose.DecryptionConfiguration;
import net.shibboleth.oidc.security.jose.EncryptionConfiguration;
import net.shibboleth.oidc.security.jose.SignatureSigningConfiguration;
import net.shibboleth.oidc.security.jose.SignatureValidationConfiguration;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.security.IdentifierGenerationStrategy;
import org.opensaml.security.config.BasicSecurityConfiguration;

public class JSONSecurityConfiguration
extends BasicSecurityConfiguration {
    @Nullable
    private DecryptionConfiguration jwtDecryptConfig;
    @Nullable
    private EncryptionConfiguration jwtEncryptConfig;
    @Nullable
    private SignatureSigningConfiguration jwtSignatureSigningConfig;
    @Nullable
    private SignatureValidationConfiguration jwtSignatureValidationConfig;

    public JSONSecurityConfiguration() {
    }

    public JSONSecurityConfiguration(@Nonnull @ParameterName(name="clockSkew") Duration skew, @Nonnull @ParameterName(name="idGenerator") IdentifierGenerationStrategy generator) {
        super(skew, generator);
    }

    public void setJwtDecryptionConfiguration(@Nullable DecryptionConfiguration config) {
        this.jwtDecryptConfig = config;
    }

    @Nullable
    public DecryptionConfiguration getJwtDecryptionConfiguration() {
        return this.jwtDecryptConfig;
    }

    public void setJwtEncryptionConfiguration(@Nullable EncryptionConfiguration config) {
        this.jwtEncryptConfig = config;
    }

    @Nullable
    public EncryptionConfiguration getJwtEncryptionConfiguration() {
        return this.jwtEncryptConfig;
    }

    public void setJwtSignatureSigningConfiguration(@Nullable SignatureSigningConfiguration config) {
        this.jwtSignatureSigningConfig = config;
    }

    @Nullable
    public SignatureSigningConfiguration getJwtSignatureSigningConfiguration() {
        return this.jwtSignatureSigningConfig;
    }

    public void setJwtSignatureValidationConfiguration(@Nullable SignatureValidationConfiguration config) {
        this.jwtSignatureValidationConfig = config;
    }

    @Nullable
    public SignatureValidationConfiguration getJwtSignatureValidationConfiguration() {
        return this.jwtSignatureValidationConfig;
    }
}

