/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.cache;

import java.time.Duration;
import java.time.Instant;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import net.shibboleth.shared.logic.Constraint;

@Immutable
public class ExpirationTimeContext<T> {
    @Nonnull
    private final T metadata;
    @Nonnull
    private final Duration minCacheDuration;
    @Nonnull
    private final Duration maxCacheDuration;
    @Nonnull
    private final Instant now;

    public ExpirationTimeContext(@Nonnull T metadataIn, @Nonnull Duration minimumCacheDuration, @Nonnull Duration maximumCacheDuration, @Nonnull Instant timeNow) {
        this.metadata = Constraint.isNotNull(metadataIn, (String)"Metadata to base expiry off can not be null");
        this.minCacheDuration = (Duration)Constraint.isNotNull((Object)minimumCacheDuration, (String)"Min cache duration can not be null");
        this.maxCacheDuration = (Duration)Constraint.isNotNull((Object)maximumCacheDuration, (String)"Max cache duration can not be null");
        this.now = timeNow;
    }

    public final T getMetadata() {
        return this.metadata;
    }

    public final Duration getMinCacheDuration() {
        return this.minCacheDuration;
    }

    public final Duration getMaxCacheDuration() {
        return this.maxCacheDuration;
    }

    public final Instant getNow() {
        return this.now;
    }
}

