/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.saml.xmlobject.impl;

import com.google.common.base.Strings;
import javax.annotation.Nonnull;
import net.shibboleth.oidc.saml.xmlobject.DefaultAcrValue;
import net.shibboleth.oidc.saml.xmlobject.OAuthRPExtensions;
import net.shibboleth.oidc.saml.xmlobject.PostLogoutRedirectUri;
import net.shibboleth.oidc.saml.xmlobject.RequestUri;
import org.opensaml.core.xml.AttributeExtensibleXMLObject;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.saml.common.AbstractSAMLObjectUnmarshaller;
import org.w3c.dom.Attr;

public class OAuthRPExtensionsUnmarshaller
extends AbstractSAMLObjectUnmarshaller {
    protected void processChildElement(@Nonnull XMLObject parentSAMLObject, @Nonnull XMLObject childSAMLObject) throws UnmarshallingException {
        OAuthRPExtensions descriptor = (OAuthRPExtensions)parentSAMLObject;
        if (childSAMLObject instanceof DefaultAcrValue) {
            descriptor.getDefaultAcrValues().add((DefaultAcrValue)childSAMLObject);
        } else if (childSAMLObject instanceof RequestUri) {
            descriptor.getRequestUris().add((RequestUri)childSAMLObject);
        } else if (childSAMLObject instanceof PostLogoutRedirectUri) {
            descriptor.getPostLogoutRedirectUris().add((PostLogoutRedirectUri)childSAMLObject);
        } else {
            descriptor.getUnknownXMLObjects().add(childSAMLObject);
        }
    }

    protected void processAttribute(@Nonnull XMLObject samlObject, @Nonnull Attr attribute) throws UnmarshallingException {
        OAuthRPExtensions descriptor = (OAuthRPExtensions)samlObject;
        if (attribute.getNamespaceURI() == null) {
            if (attribute.getLocalName().equals("default_max_age") && !Strings.isNullOrEmpty((String)attribute.getValue())) {
                descriptor.setDefaultMaxAge(Integer.parseInt(attribute.getValue()));
            } else if (attribute.getLocalName().equals("require_auth_time") && !Strings.isNullOrEmpty((String)attribute.getValue())) {
                descriptor.setRequireAuthTime(Boolean.parseBoolean(attribute.getValue()));
            } else if (attribute.getLocalName().equals("token_endpoint_auth_method")) {
                descriptor.setTokenEndpointAuthMethod(attribute.getValue());
            } else if (attribute.getLocalName().equals("grant_types")) {
                descriptor.setGrantTypes(attribute.getValue());
            } else if (attribute.getLocalName().equals("response_types")) {
                descriptor.setResponseTypes(attribute.getValue());
            } else if (attribute.getLocalName().equals("application_type")) {
                descriptor.setApplicationType(attribute.getValue());
            } else if (attribute.getLocalName().equals("client_uri")) {
                descriptor.setClientUri(attribute.getValue());
            } else if (attribute.getLocalName().equals("scopes")) {
                descriptor.setScopes(attribute.getValue());
            } else if (attribute.getLocalName().equals("software_id")) {
                descriptor.setSoftwareId(attribute.getValue());
            } else if (attribute.getLocalName().equals("software_version")) {
                descriptor.setSoftwareVersion(attribute.getValue());
            } else if (attribute.getLocalName().equals("sector_identifier_uri")) {
                descriptor.setSectorIdentifierUri(attribute.getValue());
            } else if (attribute.getLocalName().equals("id_token_signed_response_alg")) {
                descriptor.setIdTokenSignedResponseAlg(attribute.getValue());
            } else if (attribute.getLocalName().equals("id_token_encrypted_response_alg")) {
                descriptor.setIdTokenEncryptedResponseAlg(attribute.getValue());
            } else if (attribute.getLocalName().equals("id_token_encrypted_response_enc")) {
                descriptor.setIdTokenEncryptedResponseEnc(attribute.getValue());
            } else if (attribute.getLocalName().equals("userinfo_signed_response_alg")) {
                descriptor.setUserInfoSignedResponseAlg(attribute.getValue());
            } else if (attribute.getLocalName().equals("userinfo_encrypted_response_alg")) {
                descriptor.setUserInfoEncryptedResponseAlg(attribute.getValue());
            } else if (attribute.getLocalName().equals("userinfo_encrypted_response_enc")) {
                descriptor.setUserInfoEncryptedResponseEnc(attribute.getValue());
            } else if (attribute.getLocalName().equals("request_object_signing_alg")) {
                descriptor.setRequestObjectSigningAlg(attribute.getValue());
            } else if (attribute.getLocalName().equals("request_object_encryption_alg")) {
                descriptor.setRequestObjectEncryptionAlg(attribute.getValue());
            } else if (attribute.getLocalName().equals("request_object_encryption_enc")) {
                descriptor.setRequestObjectEncryptionEnc(attribute.getValue());
            } else if (attribute.getLocalName().equals("token_endpoint_auth_signing_alg")) {
                descriptor.setTokenEndpointAuthSigningAlg(attribute.getValue());
            } else if (attribute.getLocalName().equals("initiate_login_uri")) {
                descriptor.setInitiateLoginUri(attribute.getValue());
            } else if (attribute.getLocalName().equals("backchannel_logout_session_required") && !Strings.isNullOrEmpty((String)attribute.getValue())) {
                descriptor.setBackChannelLogoutSessionRequired(Boolean.parseBoolean(attribute.getValue()));
            } else if (attribute.getLocalName().equals("frontchannel_logout_session_required") && !Strings.isNullOrEmpty((String)attribute.getValue())) {
                descriptor.setFrontChannelLogoutSessionRequired(Boolean.parseBoolean(attribute.getValue()));
            } else {
                super.processAttribute(samlObject, attribute);
            }
        } else {
            this.processUnknownAttribute((AttributeExtensibleXMLObject)descriptor, attribute);
        }
    }
}

