/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.oauth2.config.impl;

import java.time.Duration;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.profile.oauth2.config.OAuth2TokenAudienceConfiguration;
import net.shibboleth.oidc.profile.oauth2.config.impl.AbstractOAuth2InterceptorAwareProfileConfiguration;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.Positive;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;

public class DefaultOAuth2TokenAudienceConfiguration
extends AbstractOAuth2InterceptorAwareProfileConfiguration
implements OAuth2TokenAudienceConfiguration {
    @Nonnull
    private Function<ProfileRequestContext, String> issuerLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    private Predicate<ProfileRequestContext> resolveAttributesPredicate = PredicateSupport.alwaysTrue();
    @Nonnull
    private Predicate<ProfileRequestContext> encryptionOptionalPredicate = PredicateSupport.alwaysFalse();
    @Nonnull
    private Function<ProfileRequestContext, String> accessTokenTypeLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    private Function<ProfileRequestContext, Duration> accessTokenLifetimeLookupStrategy = FunctionSupport.constant((Object)Duration.ofMinutes(10L));
    @Nonnull
    private Function<ProfileRequestContext, BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>>> accessTokenClaimsSetManipulationStrategyLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    private Predicate<ProfileRequestContext> alwaysIssueBearerAccessTokenPredicate = PredicateSupport.alwaysFalse();

    public DefaultOAuth2TokenAudienceConfiguration() {
        this("http://shibboleth.net/ns/profiles/oauth2/token/audience");
    }

    public DefaultOAuth2TokenAudienceConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
    }

    @Nullable
    @NotEmpty
    public String getIssuer(@Nullable ProfileRequestContext profileRequestContext) {
        return this.issuerLookupStrategy.apply(profileRequestContext);
    }

    public void setIssuer(@Nullable @NotEmpty String issuer) {
        this.issuerLookupStrategy = FunctionSupport.constant((Object)issuer);
    }

    public void setIssuerLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.issuerLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Issuer lookup strategy cannot be null");
    }

    public boolean isResolveAttributes(@Nullable ProfileRequestContext profileRequestContext) {
        return this.resolveAttributesPredicate.test(profileRequestContext);
    }

    public void setResolveAttributes(boolean flag) {
        this.resolveAttributesPredicate = flag ? PredicateSupport.alwaysTrue() : PredicateSupport.alwaysFalse();
    }

    public void setResolveAttributesPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.resolveAttributesPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Resolve attributes predicate cannot be null");
    }

    public boolean isEncryptionOptional(@Nullable ProfileRequestContext profileRequestContext) {
        return this.encryptionOptionalPredicate.test(profileRequestContext);
    }

    public void setEncryptionOptional(boolean flag) {
        this.encryptionOptionalPredicate = flag ? PredicateSupport.alwaysTrue() : PredicateSupport.alwaysFalse();
    }

    public void setEncryptionOptionalPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.encryptionOptionalPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Encryption optional predicate cannot be null");
    }

    @Nullable
    @NotEmpty
    public String getAccessTokenType(@Nullable ProfileRequestContext profileRequestContext) {
        return this.accessTokenTypeLookupStrategy.apply(profileRequestContext);
    }

    public void setAccessTokenType(@Nullable @NotEmpty String type) {
        this.accessTokenTypeLookupStrategy = FunctionSupport.constant((Object)StringSupport.trimOrNull((String)type));
    }

    public void setAccessTokenTypeLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.accessTokenTypeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nonnull
    @Positive
    public Duration getAccessTokenLifetime(@Nullable ProfileRequestContext profileRequestContext) {
        Duration lifetime = this.accessTokenLifetimeLookupStrategy.apply(profileRequestContext);
        Constraint.isTrue((lifetime != null && !lifetime.isZero() && !lifetime.isNegative() ? 1 : 0) != 0, (String)"Access token lifetime must be greater than 0");
        assert (lifetime != null);
        return lifetime;
    }

    public void setAccessTokenLifetime(@Nonnull @Positive Duration lifetime) {
        Duration tokenLifetime = (Duration)Constraint.isNotNull((Object)lifetime, (String)"Access token lifetime cannot be null");
        Constraint.isTrue((!tokenLifetime.isZero() && !tokenLifetime.isNegative() ? 1 : 0) != 0, (String)"Access token lifetime must be greater than 0");
        this.accessTokenLifetimeLookupStrategy = FunctionSupport.constant((Object)tokenLifetime);
    }

    public void setAccessTokenLifetimeLookupStrategy(@Nullable Function<ProfileRequestContext, Duration> strategy) {
        this.accessTokenLifetimeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nullable
    public BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>> getAccessTokenClaimsSetManipulationStrategy(@Nullable ProfileRequestContext profileRequestContext) {
        return this.accessTokenClaimsSetManipulationStrategyLookupStrategy.apply(profileRequestContext);
    }

    public void setAccessTokenClaimsSetManipulationStrategy(@Nullable BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>> strategy) {
        this.accessTokenClaimsSetManipulationStrategyLookupStrategy = FunctionSupport.constant(strategy);
    }

    public void setAccessTokenClaimsSetManipulationStrategyLookupStrategy(@Nonnull Function<ProfileRequestContext, BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>>> strategy) {
        this.accessTokenClaimsSetManipulationStrategyLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    public boolean isAlwaysIssueBearerAccessToken(@Nullable ProfileRequestContext profileRequestContext) {
        return this.alwaysIssueBearerAccessTokenPredicate.test(profileRequestContext);
    }

    public void setAlwaysIssueBearerAccessToken(boolean flag) {
        this.alwaysIssueBearerAccessTokenPredicate = flag ? PredicateSupport.alwaysTrue() : PredicateSupport.alwaysFalse();
    }

    public void setAlwaysIssueBearerAccessTokenPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.alwaysIssueBearerAccessTokenPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Always issue bearer access token predicate cannot be null");
    }
}

