/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.oauth2.config.impl;

import java.time.Duration;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.profile.config.impl.DefaultOIDCAuthorizationConfiguration;
import net.shibboleth.oidc.profile.oauth2.config.OAuth2PushedAuthorizationRequestConfiguration;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.Positive;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;

public class DefaultOAuth2PushedAuthorizationRequestConfiguration
extends DefaultOIDCAuthorizationConfiguration
implements OAuth2PushedAuthorizationRequestConfiguration {
    @Nonnull
    @NotEmpty
    public static final String PROFILE_COUNTER = "net.shibboleth.idp.profiles.oauth2.par";
    @Nonnull
    private Function<ProfileRequestContext, String> issuerLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    private Function<ProfileRequestContext, String> requestUriTypeLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    private Function<ProfileRequestContext, Duration> requestUriLifetimeLookupStrategy = FunctionSupport.constant((Object)Duration.ofMinutes(1L));
    @Nonnull
    private Function<ProfileRequestContext, BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>>> requestUriClaimsSetManipulationStrategyLookupStrategy = FunctionSupport.constant(null);

    public DefaultOAuth2PushedAuthorizationRequestConfiguration() {
        this("http://shibboleth.net/ns/profiles/oauth2/par");
    }

    public DefaultOAuth2PushedAuthorizationRequestConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
    }

    @Override
    @Nullable
    @NotEmpty
    public String getIssuer(@Nullable ProfileRequestContext profileRequestContext) {
        return this.issuerLookupStrategy.apply(profileRequestContext);
    }

    @Override
    public void setIssuer(@Nullable @NotEmpty String issuer) {
        this.issuerLookupStrategy = FunctionSupport.constant((Object)issuer);
    }

    @Override
    public void setIssuerLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.issuerLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Issuer lookup strategy cannot be null");
    }

    @Nullable
    @NotEmpty
    public String getRequestUriType(@Nullable ProfileRequestContext profileRequestContext) {
        return this.requestUriTypeLookupStrategy.apply(profileRequestContext);
    }

    public void setRequestUriType(@Nullable @NotEmpty String type) {
        this.requestUriTypeLookupStrategy = FunctionSupport.constant((Object)StringSupport.trimOrNull((String)type));
    }

    public void setRequestUriTypeLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.requestUriTypeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nonnull
    @Positive
    public Duration getRequestUriLifetime(@Nullable ProfileRequestContext profileRequestContext) {
        Duration lifetime = this.requestUriLifetimeLookupStrategy.apply(profileRequestContext);
        Constraint.isTrue((lifetime != null && !lifetime.isZero() && !lifetime.isNegative() ? 1 : 0) != 0, (String)"Request URI lifetime must be greater than 0");
        assert (lifetime != null);
        return lifetime;
    }

    public void setRequestUriLifetime(@Nonnull @Positive Duration lifetime) {
        Duration tokenLifetime = (Duration)Constraint.isNotNull((Object)lifetime, (String)"request URI lifetime cannot be null");
        Constraint.isTrue((!tokenLifetime.isZero() && !tokenLifetime.isNegative() ? 1 : 0) != 0, (String)"request URI lifetime must be greater than 0");
        this.requestUriLifetimeLookupStrategy = FunctionSupport.constant((Object)tokenLifetime);
    }

    public void setRequestUriLifetimeLookupStrategy(@Nullable Function<ProfileRequestContext, Duration> strategy) {
        this.requestUriLifetimeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nullable
    public BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>> getRequestUriClaimsSetManipulationStrategy(@Nullable ProfileRequestContext profileRequestContext) {
        return this.requestUriClaimsSetManipulationStrategyLookupStrategy.apply(profileRequestContext);
    }

    public void setRequestUriClaimsSetManipulationStrategy(@Nullable BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>> strategy) {
        this.requestUriClaimsSetManipulationStrategyLookupStrategy = FunctionSupport.constant(strategy);
    }

    public void setRequestUriClaimsSetManipulationStrategyLookupStrategy(@Nonnull Function<ProfileRequestContext, BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>>> strategy) {
        this.requestUriClaimsSetManipulationStrategyLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }
}

