/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.oauth2.config.impl;

import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import java.security.Principal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.jwt.claims.ClaimsValidator;
import net.shibboleth.oidc.metadata.policy.UnregisteredClientPolicy;
import net.shibboleth.oidc.profile.oauth2.config.OAuth2ClientAuthenticableClientProfileConfiguration;
import net.shibboleth.oidc.profile.oauth2.config.OAuth2ClientAuthenticableProfileConfiguration;
import net.shibboleth.oidc.profile.oauth2.config.impl.AbstractOAuth2InterceptorAwareProfileConfiguration;
import net.shibboleth.oidc.security.credential.ClientSecretCredential;
import net.shibboleth.oidc.security.jose.SignatureValidationConfiguration;
import net.shibboleth.shared.annotation.constraint.NonNegative;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;

public abstract class AbstractOAuth2ClientAuthenticableProfileConfiguration
extends AbstractOAuth2InterceptorAwareProfileConfiguration
implements OAuth2ClientAuthenticableProfileConfiguration,
OAuth2ClientAuthenticableClientProfileConfiguration {
    @Nonnull
    private Function<ProfileRequestContext, Set<String>> tokenEndpointAuthMethodsLookupStrategy = FunctionSupport.constant((Object)CollectionSupport.setOf((Object[])new String[]{ClientAuthenticationMethod.CLIENT_SECRET_BASIC.toString(), ClientAuthenticationMethod.CLIENT_SECRET_POST.toString(), ClientAuthenticationMethod.CLIENT_SECRET_JWT.toString(), ClientAuthenticationMethod.PRIVATE_KEY_JWT.toString()}));
    @Nonnull
    private Function<ProfileRequestContext, String> tokenEndpointAuthMethodLookupStrategy = FunctionSupport.constant((Object)ClientAuthenticationMethod.CLIENT_SECRET_BASIC.toString());
    @Nonnull
    private Function<ProfileRequestContext, ClaimsValidator> claimsValidatorLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    private Predicate<ProfileRequestContext> forceAuthnPredicate = PredicateSupport.alwaysFalse();
    @Nonnull
    private Function<ProfileRequestContext, Integer> proxyCountLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    private Function<ProfileRequestContext, Collection<Principal>> defaultAuthenticationContextsLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    private Function<ProfileRequestContext, Set<String>> authenticationFlowsLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    private Function<ProfileRequestContext, Collection<String>> postAuthenticationFlowsLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    private Function<ProfileRequestContext, ClientSecretCredential> clientCredentialLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    private Function<ProfileRequestContext, String> clientIdLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    private Function<ProfileRequestContext, Map<String, UnregisteredClientPolicy>> unregisteredClientPolicyLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    private Function<ProfileRequestContext, ClaimsValidator> dpopProofClaimsValidatorLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    private Function<ProfileRequestContext, SignatureValidationConfiguration> dpopSignatureValidationConfigurationLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    private Predicate<ProfileRequestContext> requireDpopProofPredicate = PredicateSupport.alwaysFalse();
    @Nonnull
    private Function<ProfileRequestContext, Function<ProfileRequestContext, String>> dpopProofNonceGeneratorLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    private Predicate<ProfileRequestContext> useTargetedEndpointAsJWTAudiencePredicate = PredicateSupport.alwaysTrue();
    @Nonnull
    private Function<ProfileRequestContext, String> clientAuthenticationJWTTypeLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    private Predicate<ProfileRequestContext> requireSingleJWTAudiencePredicate = PredicateSupport.alwaysFalse();

    protected AbstractOAuth2ClientAuthenticableProfileConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public Set<String> getTokenEndpointAuthMethods(@Nullable ProfileRequestContext profileRequestContext) {
        Collection methods = this.tokenEndpointAuthMethodsLookupStrategy.apply(profileRequestContext);
        if (methods != null) {
            return CollectionSupport.copyToSet((Collection)methods);
        }
        return CollectionSupport.emptySet();
    }

    public void setTokenEndpointAuthMethods(@Nonnull @NonnullElements Collection<String> methods) {
        Constraint.isNotNull(methods, (String)"Collection of methods cannot be null");
        this.tokenEndpointAuthMethodsLookupStrategy = FunctionSupport.constant(Set.copyOf(StringSupport.normalizeStringCollection(methods)));
    }

    public void setTokenEndpointAuthMethodsLookupStrategy(@Nonnull Function<ProfileRequestContext, Set<String>> strategy) {
        this.tokenEndpointAuthMethodsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nullable
    public String getTokenEndpointAuthMethod(@Nullable ProfileRequestContext profileRequestContext) {
        return this.tokenEndpointAuthMethodLookupStrategy.apply(profileRequestContext);
    }

    public void setTokenEndpointAuthMethod(@Nonnull @NonnullElements String method) {
        this.tokenEndpointAuthMethodLookupStrategy = FunctionSupport.constant((Object)((String)Constraint.isNotNull((Object)method, (String)"Collection of methods cannot be null")));
    }

    public void setTokenEndpointAuthMethodLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.tokenEndpointAuthMethodLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nullable
    public ClaimsValidator getClaimsValidator(@Nullable ProfileRequestContext profileRequestContext) {
        return this.claimsValidatorLookupStrategy.apply(profileRequestContext);
    }

    public void setClaimsValidator(@Nullable ClaimsValidator validator) {
        this.claimsValidatorLookupStrategy = FunctionSupport.constant((Object)validator);
    }

    public void setClaimsValidatorLookupStrategy(@Nonnull Function<ProfileRequestContext, ClaimsValidator> strategy) {
        this.claimsValidatorLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    public boolean isForceAuthn(@Nullable ProfileRequestContext profileRequestContext) {
        return this.forceAuthnPredicate.test(profileRequestContext);
    }

    public void setForceAuthn(boolean flag) {
        this.forceAuthnPredicate = flag ? PredicateSupport.alwaysTrue() : PredicateSupport.alwaysFalse();
    }

    public void setForceAuthnPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.forceAuthnPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Forced authentication predicate cannot be null");
    }

    @Nullable
    public Integer getProxyCount(@Nullable ProfileRequestContext profileRequestContext) {
        Integer count = this.proxyCountLookupStrategy.apply(profileRequestContext);
        if (count != null) {
            Constraint.isGreaterThanOrEqual((int)0, (int)count, (String)"Proxy count must be greater than or equal to 0");
        }
        return count;
    }

    public void setProxyCount(@Nullable @NonNegative Integer count) {
        if (count != null) {
            Constraint.isGreaterThanOrEqual((int)0, (int)count, (String)"Proxy count must be greater than or equal to 0");
        }
        this.proxyCountLookupStrategy = FunctionSupport.constant((Object)count);
    }

    public void setProxyCountLookupStrategy(@Nonnull Function<ProfileRequestContext, Integer> strategy) {
        this.proxyCountLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public Set<String> getAuthenticationFlows(@Nullable ProfileRequestContext profileRequestContext) {
        Set<String> flows = this.authenticationFlowsLookupStrategy.apply(profileRequestContext);
        if (flows != null) {
            return CollectionSupport.copyToSet(flows);
        }
        return CollectionSupport.emptySet();
    }

    public void setAuthenticationFlows(@Nullable @NonnullElements Collection<String> flows) {
        this.authenticationFlowsLookupStrategy = flows != null ? FunctionSupport.constant(Set.copyOf(StringSupport.normalizeStringCollection(flows))) : FunctionSupport.constant(null);
    }

    public void setAuthenticationFlowsLookupStrategy(@Nonnull Function<ProfileRequestContext, Set<String>> strategy) {
        this.authenticationFlowsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public List<String> getPostAuthenticationFlows(@Nullable ProfileRequestContext profileRequestContext) {
        Collection<String> flows = this.postAuthenticationFlowsLookupStrategy.apply(profileRequestContext);
        if (flows != null) {
            return CollectionSupport.copyToList(flows);
        }
        return CollectionSupport.emptyList();
    }

    public void setPostAuthenticationFlows(@Nullable @NonnullElements Collection<String> flows) {
        this.postAuthenticationFlowsLookupStrategy = flows != null ? FunctionSupport.constant(List.copyOf(StringSupport.normalizeStringCollection(flows))) : FunctionSupport.constant(null);
    }

    public void setPostAuthenticationFlowsLookupStrategy(@Nonnull Function<ProfileRequestContext, Collection<String>> strategy) {
        this.postAuthenticationFlowsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public List<Principal> getDefaultAuthenticationMethods(@Nullable ProfileRequestContext profileRequestContext) {
        Collection<Principal> methods = this.defaultAuthenticationContextsLookupStrategy.apply(profileRequestContext);
        if (methods != null) {
            return CollectionSupport.copyToList(methods);
        }
        return CollectionSupport.emptyList();
    }

    public void setDefaultAuthenticationMethods(@Nullable @NonnullElements Collection<Principal> contexts) {
        this.defaultAuthenticationContextsLookupStrategy = contexts != null ? FunctionSupport.constant((Object)CollectionSupport.copyToList(contexts)) : FunctionSupport.constant(null);
    }

    public void setDefaultAuthenticationMethodsLookupStrategy(@Nonnull Function<ProfileRequestContext, Collection<Principal>> strategy) {
        this.defaultAuthenticationContextsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    public void setClientCredentialLookupStrategy(@Nonnull Function<ProfileRequestContext, ClientSecretCredential> strategy) {
        this.clientCredentialLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Client credential lookup strategy can not be null");
    }

    public void setClientCredential(@Nullable ClientSecretCredential clientCredential) {
        this.clientCredentialLookupStrategy = FunctionSupport.constant((Object)clientCredential);
    }

    public ClientSecretCredential getClientCredential(@Nullable ProfileRequestContext profileRequestContext) {
        return this.clientCredentialLookupStrategy.apply(profileRequestContext);
    }

    public void setClientIdLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.clientIdLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Client ID lookup strategy can not be null");
    }

    public void setClientId(@Nullable String clientId) {
        this.clientIdLookupStrategy = FunctionSupport.constant((Object)StringSupport.trimOrNull((String)clientId));
    }

    @Nullable
    public String getClientId(@Nullable ProfileRequestContext profileRequestContext) {
        return this.clientIdLookupStrategy.apply(profileRequestContext);
    }

    @Nonnull
    @Unmodifiable
    public Map<String, UnregisteredClientPolicy> getUnregisteredClientPolicy(@Nullable ProfileRequestContext profileRequestContext) {
        Map<String, UnregisteredClientPolicy> result = this.unregisteredClientPolicyLookupStrategy.apply(profileRequestContext);
        if (result == null) {
            return CollectionSupport.emptyMap();
        }
        return CollectionSupport.copyToMap(result);
    }

    public void setUnregisteredClientPolicy(@Nullable Map<String, UnregisteredClientPolicy> policy) {
        this.unregisteredClientPolicyLookupStrategy = FunctionSupport.constant(policy);
    }

    public void setUnregisteredClientPolicyLookupStrategy(@Nonnull Function<ProfileRequestContext, Map<String, UnregisteredClientPolicy>> strategy) {
        this.unregisteredClientPolicyLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nullable
    public ClaimsValidator getDpopProofClaimsValidator(@Nullable ProfileRequestContext profileRequestContext) {
        return this.dpopProofClaimsValidatorLookupStrategy.apply(profileRequestContext);
    }

    public void setDpopProofClaimsValidator(@Nullable ClaimsValidator validator) {
        this.dpopProofClaimsValidatorLookupStrategy = FunctionSupport.constant((Object)validator);
    }

    public void setDpopProofClaimsValidatorLookupStrategy(@Nonnull Function<ProfileRequestContext, ClaimsValidator> strategy) {
        this.dpopProofClaimsValidatorLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nullable
    public SignatureValidationConfiguration getDpopProofSignatureValidationConfiguration(@Nullable ProfileRequestContext profileRequestContext) {
        return this.dpopSignatureValidationConfigurationLookupStrategy.apply(profileRequestContext);
    }

    public void setDpopProofSignatureValidationConfiguration(@Nullable SignatureValidationConfiguration configuration) {
        this.dpopSignatureValidationConfigurationLookupStrategy = FunctionSupport.constant((Object)configuration);
    }

    public void setDpopProofSignatureValidationConfigurationLookupStrategy(@Nonnull Function<ProfileRequestContext, SignatureValidationConfiguration> strategy) {
        this.dpopSignatureValidationConfigurationLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    public boolean isRequireDpopProof(@Nullable ProfileRequestContext profileRequestContext) {
        return this.requireDpopProofPredicate.test(profileRequestContext);
    }

    public void setRequireDpopProof(boolean flag) {
        this.requireDpopProofPredicate = flag ? PredicateSupport.alwaysTrue() : PredicateSupport.alwaysFalse();
    }

    public void setRequireDpopProofPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.requireDpopProofPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Condition cannot be null");
    }

    @Nullable
    public Function<ProfileRequestContext, String> getDpopProofNonceGenerator(@Nullable ProfileRequestContext profileRequestContext) {
        return this.dpopProofNonceGeneratorLookupStrategy.apply(profileRequestContext);
    }

    public void setDpopProofNonceGenerator(@Nullable Function<ProfileRequestContext, String> function) {
        this.dpopProofNonceGeneratorLookupStrategy = FunctionSupport.constant(function);
    }

    public void setDpopProofNonceGeneratorLookupStrategy(@Nonnull Function<ProfileRequestContext, Function<ProfileRequestContext, String>> strategy) {
        this.dpopProofNonceGeneratorLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    public boolean isUseTargetedEndpointAsJWTAudience(@Nullable ProfileRequestContext profileRequestContext) {
        return this.useTargetedEndpointAsJWTAudiencePredicate.test(profileRequestContext);
    }

    public void setUseTargetedEndpointAsJWTAudiencePredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.useTargetedEndpointAsJWTAudiencePredicate = (Predicate)Constraint.isNotNull(condition, (String)"UseTargetedEndpointAsJWTAudience Condition cannot be null");
    }

    public void setUseTargetedEndpointAsJWTAudience(boolean flag) {
        this.useTargetedEndpointAsJWTAudiencePredicate = flag ? PredicateSupport.alwaysTrue() : PredicateSupport.alwaysFalse();
    }

    @Nullable
    public String getClientAuthenticationJWTType(@Nullable ProfileRequestContext profileRequestContext) {
        return this.clientAuthenticationJWTTypeLookupStrategy.apply(profileRequestContext);
    }

    public void setClientAuthenticationJWTTypeLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.clientAuthenticationJWTTypeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"ClientAuthenticationJWTTypeLookupStrategy can not be null");
    }

    public void setClientAuthenticationJWTType(@Nullable String type) {
        this.clientAuthenticationJWTTypeLookupStrategy = FunctionSupport.constant((Object)type);
    }

    public boolean isRequireSingleJWTAudience(@Nullable ProfileRequestContext profileRequestContext) {
        return this.requireSingleJWTAudiencePredicate.test(profileRequestContext);
    }

    public void setRequireSingleJWTAudiencePredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.requireSingleJWTAudiencePredicate = (Predicate)Constraint.isNotNull(condition, (String)"RequireSingleJWTAudiencePredicate Condition cannot be null");
    }

    public void setRequireSingleJWTAudience(boolean flag) {
        this.requireSingleJWTAudiencePredicate = flag ? PredicateSupport.alwaysTrue() : PredicateSupport.alwaysFalse();
    }
}

