/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.impl;

import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.oidc.security.jose.SignatureValidationConfiguration;
import net.shibboleth.oidc.security.jose.SignatureValidationParameters;
import net.shibboleth.oidc.security.jose.SignatureValidationParametersResolver;
import net.shibboleth.oidc.security.jose.context.SecurityParametersContext;
import net.shibboleth.oidc.security.jose.criterion.SignatureValidationConfigurationCriterion;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.slf4j.Logger;

public class PopulateJWTSignatureValidationParametersHandler
extends AbstractMessageHandler {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PopulateJWTSignatureValidationParametersHandler.class);
    @Nonnull
    private Function<MessageContext, SecurityParametersContext> securityParametersContextLookupStrategy = new ChildContextLookup(SecurityParametersContext.class, true);
    @NonnullAfterInit
    private Function<MessageContext, List<SignatureValidationConfiguration>> configurationLookupStrategy;
    @NonnullAfterInit
    private SignatureValidationParametersResolver resolver;

    public void setSecurityParametersContextLookupStrategy(@Nonnull Function<MessageContext, SecurityParametersContext> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.securityParametersContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SecurityParametersContext lookup strategy cannot be null");
    }

    public void setConfigurationLookupStrategy(@Nonnull Function<MessageContext, List<SignatureValidationConfiguration>> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.configurationLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SignatureValidationConfiguration lookup strategy cannot be null");
    }

    public void setSignatureValidationParametersResolver(@Nonnull SignatureValidationParametersResolver newResolver) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.resolver = (SignatureValidationParametersResolver)Constraint.isNotNull((Object)newResolver, (String)"SignatureValidationParametersResolver cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.resolver == null) {
            throw new ComponentInitializationException("SignatureValidationParametersResolver cannot be null");
        }
        if (this.configurationLookupStrategy == null) {
            throw new ComponentInitializationException("ConfigurationLookupStrategy cannot be null");
        }
    }

    protected void doInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        this.log.debug("{} Resolving SignatureValidationParameters for request", (Object)this.getLogPrefix());
        List<SignatureValidationConfiguration> configs = this.configurationLookupStrategy.apply(messageContext);
        if (configs == null || configs.isEmpty()) {
            this.log.error("{} No SignatureValidationConfiguration returned by lookup strategy", (Object)this.getLogPrefix());
            throw new MessageHandlerException("No SignatureValidationConfiguration returned by lookup strategy");
        }
        SecurityParametersContext paramsCtx = this.securityParametersContextLookupStrategy.apply(messageContext);
        if (paramsCtx == null) {
            this.log.debug("{} No SecurityParametersContext returned by lookup strategy", (Object)this.getLogPrefix());
            throw new MessageHandlerException("SecurityParametersContext returned by lookup strategy");
        }
        try {
            SignatureValidationParameters params = (SignatureValidationParameters)this.resolver.resolveSingle((Object)new CriteriaSet(new Criterion[]{new SignatureValidationConfigurationCriterion(configs)}));
            paramsCtx.setSignatureValidationParameters(params);
            this.log.debug("{} {} SignatureValidationParameters", (Object)this.getLogPrefix(), (Object)(params != null ? "Resolved" : "Failed to resolve"));
        }
        catch (ResolverException e) {
            this.log.error("{} Error resolving SignatureValidationParameters: {}", (Object)this.getLogPrefix(), (Object)e.getMessage());
            throw new MessageHandlerException("Error resolving SignatureValidationParameters");
        }
    }
}

