/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.impl;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.oidc.profile.config.OIDCAuthorizationConfiguration;
import net.shibboleth.oidc.profile.encoding.OIDCMessageEncoder;
import net.shibboleth.oidc.profile.oauth2.config.OAuth2AuthorizationProfileConfiguration;
import net.shibboleth.profile.config.ProfileConfiguration;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.encoder.MessageEncoder;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

@ThreadSafe
public class AuthenticationRequestMessageEncoderFactory
extends AbstractInitializableComponent
implements Function<ProfileRequestContext, MessageEncoder> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AuthenticationRequestMessageEncoderFactory.class);
    @Nonnull
    @Unmodifiable
    @NotLive
    private final List<OIDCMessageEncoder> encoders;

    public AuthenticationRequestMessageEncoderFactory(@Nullable @ParameterName(name="encoders") List<OIDCMessageEncoder> encodersToUse) {
        this.encoders = encodersToUse == null ? CollectionSupport.emptyList() : CollectionSupport.copyToList(encodersToUse);
    }

    @Override
    @Nullable
    public MessageEncoder apply(@Nullable ProfileRequestContext input) {
        ProfileConfiguration profileConfiguration;
        RelyingPartyContext rpCtx = input != null ? (RelyingPartyContext)input.getSubcontext(RelyingPartyContext.class) : null;
        OIDCAuthorizationConfiguration profileConfiguration2 = null;
        if (rpCtx != null && (profileConfiguration = rpCtx.getProfileConfig()) instanceof OIDCAuthorizationConfiguration) {
            OIDCAuthorizationConfiguration downcast;
            profileConfiguration2 = downcast = (OIDCAuthorizationConfiguration)profileConfiguration;
        }
        if (profileConfiguration2 == null) {
            this.log.warn("OIDCAuthorizationConfiguration not found, no encoders to lookup");
            return null;
        }
        OAuth2AuthorizationProfileConfiguration.HttpRequestMethod requestMethodFromConfig = profileConfiguration2.getHttpRequestMethod(input);
        if (requestMethodFromConfig == null) {
            this.log.warn("Authentication request method not found on profile, no encoders to lookup");
            return null;
        }
        Optional<OIDCMessageEncoder> encoder = this.encoders.stream().filter(enc -> enc.test((Object)requestMethodFromConfig)).findFirst();
        if (encoder.isPresent()) {
            this.log.trace("Returning OIDC message encoder of type '{}'", encoder.get().getClass());
        } else {
            this.log.warn("No message encoder was found for authentication request method type '{}'", (Object)requestMethodFromConfig);
        }
        return encoder.orElse(null);
    }
}

