/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.config.impl;

import java.util.Collection;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.profile.config.OIDCUserInfoConfiguration;
import net.shibboleth.oidc.profile.oauth2.config.impl.AbstractOAuth2TokenValidatingConfiguration;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;

public class DefaultOIDCUserInfoConfiguration
extends AbstractOAuth2TokenValidatingConfiguration
implements OIDCUserInfoConfiguration {
    @Nonnull
    @NotEmpty
    public static final String PROFILE_COUNTER = "net.shibboleth.idp.profiles.oidc.userinfo";
    @Nonnull
    private Predicate<ProfileRequestContext> resolveAttributesPredicate = PredicateSupport.alwaysTrue();
    @Nonnull
    private Predicate<ProfileRequestContext> encryptionOptionalPredicate = PredicateSupport.alwaysTrue();
    @Nonnull
    private Function<ProfileRequestContext, Set<String>> deniedUserInfoAttributesLookupStrategy = FunctionSupport.constant(null);

    public DefaultOIDCUserInfoConfiguration() {
        this("http://shibboleth.net/ns/profiles/oidc/userinfo");
    }

    public DefaultOIDCUserInfoConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
    }

    public boolean isResolveAttributes(@Nullable ProfileRequestContext profileRequestContext) {
        return this.resolveAttributesPredicate.test(profileRequestContext);
    }

    public void setResolveAttributes(boolean flag) {
        this.resolveAttributesPredicate = flag ? PredicateSupport.alwaysTrue() : PredicateSupport.alwaysFalse();
    }

    public void setResolveAttributesPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.resolveAttributesPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Resolve attributes predicate cannot be null");
    }

    public boolean isEncryptionOptional(@Nullable ProfileRequestContext profileRequestContext) {
        return this.encryptionOptionalPredicate.test(profileRequestContext);
    }

    public void setEncryptionOptional(boolean flag) {
        this.encryptionOptionalPredicate = flag ? PredicateSupport.alwaysTrue() : PredicateSupport.alwaysFalse();
    }

    public void setEncryptionOptionalPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.encryptionOptionalPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Encryption optional predicate cannot be null");
    }

    @Nonnull
    @NonnullElements
    @NotLive
    public Set<String> getDeniedUserInfoAttributes(@Nullable ProfileRequestContext profileRequestContext) {
        Set<String> attributes = this.deniedUserInfoAttributesLookupStrategy.apply(profileRequestContext);
        if (attributes != null) {
            return CollectionSupport.copyToSet(attributes);
        }
        return CollectionSupport.emptySet();
    }

    public void setDeniedUserInfoAttributes(@Nullable @NonnullElements Collection<String> attributes) {
        this.deniedUserInfoAttributesLookupStrategy = attributes == null || attributes.isEmpty() ? FunctionSupport.constant(null) : FunctionSupport.constant(Set.copyOf(StringSupport.normalizeStringCollection(attributes)));
    }

    public void setDeniedUserInfoAttributesLookupStrategy(@Nonnull Function<ProfileRequestContext, Set<String>> strategy) {
        this.deniedUserInfoAttributesLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }
}

