/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.config.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.profile.config.OIDCProviderInformationConfiguration;
import net.shibboleth.profile.config.AbstractConditionalProfileConfiguration;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import org.opensaml.profile.context.ProfileRequestContext;

public class DefaultOIDCProviderInformationConfiguration
extends AbstractConditionalProfileConfiguration
implements OIDCProviderInformationConfiguration {
    @Nonnull
    @NotEmpty
    public static final String PROFILE_COUNTER = "net.shibboleth.idp.profiles.oidc.configuration";
    @Nonnull
    private Function<ProfileRequestContext, String> issuerLookupStrategy = FunctionSupport.constant(null);

    public DefaultOIDCProviderInformationConfiguration() {
        this("http://shibboleth.net/ns/profiles/oidc/configuration");
    }

    public DefaultOIDCProviderInformationConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
    }

    @Nullable
    @NotEmpty
    public String getIssuer(@Nullable ProfileRequestContext profileRequestContext) {
        return this.issuerLookupStrategy.apply(profileRequestContext);
    }

    public void setIssuer(@Nullable @NotEmpty String issuer) {
        this.issuerLookupStrategy = FunctionSupport.constant((Object)issuer);
    }

    public void setIssuerLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.issuerLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Issuer lookup strategy cannot be null");
    }
}

