/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.audit.impl;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.openid.connect.sdk.claims.ClaimsSet;
import java.text.ParseException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class ClaimSetFromJWTLookupStrategy
implements Function<ProfileRequestContext, ClaimsSet> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ClaimSetFromJWTLookupStrategy.class);
    @Nonnull
    private final Function<ProfileRequestContext, JWT> jwtLookupStrategy;

    public ClaimSetFromJWTLookupStrategy(@ParameterName(name="jwtLookupStrategy") @Nonnull Function<ProfileRequestContext, JWT> strategy) {
        this.jwtLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"JWT lookup strategy can not be null");
    }

    @Override
    @Nullable
    public ClaimsSet apply(@Nullable ProfileRequestContext input) {
        JWT locatedJwt = this.jwtLookupStrategy.apply(input);
        if (locatedJwt == null) {
            return null;
        }
        try {
            JWTClaimsSet jwtClaims = locatedJwt.getJWTClaimsSet();
            if (jwtClaims != null) {
                ClaimsSet claims = new ClaimsSet();
                claims.putAll(jwtClaims.toJSONObject());
                return claims;
            }
        }
        catch (ParseException e) {
            this.log.debug("Unable to parse JWT ClaimsSet from JWT", (Throwable)e);
            return null;
        }
        return null;
    }
}

