/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.spring.relyingparty.metadata.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.metadata.ClientInformationResolver;
import net.shibboleth.oidc.metadata.RelyingPartyClientInformationProvider;
import net.shibboleth.oidc.metadata.impl.ChainingClientInformationResolver;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.NonnullFunction;
import net.shibboleth.shared.resolver.ResolverException;
import net.shibboleth.shared.service.ServiceException;
import net.shibboleth.shared.spring.service.AbstractServiceableComponent;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.context.ApplicationContext;

public class ClientInformationResolverServiceStrategy
extends AbstractIdentifiableInitializableComponent
implements NonnullFunction<ApplicationContext, AbstractServiceableComponent<ClientInformationResolver>> {
    @Nonnull
    public AbstractServiceableComponent<ClientInformationResolver> apply(@Nullable ApplicationContext appContext) {
        List resolvers;
        Collection<Object> collection = resolvers = appContext != null ? appContext.getBeansOfType(RelyingPartyClientInformationProvider.class).values() : CollectionSupport.emptyList();
        if (resolvers.isEmpty()) {
            throw new ServiceException("Reload did not produce any bean of type" + RelyingPartyClientInformationProvider.class.getName());
        }
        if (1 == resolvers.size()) {
            AbstractServiceableComponent result = (AbstractServiceableComponent)resolvers.iterator().next();
            assert (result != null);
            return result;
        }
        for (RelyingPartyClientInformationProvider resolver : resolvers) {
            try {
                resolver.initialize();
            }
            catch (ComponentInitializationException e) {
                throw new BeanCreationException("could not preinitialize , client information provider " + resolver.getId(), (Throwable)e);
            }
        }
        ArrayList resolverList = new ArrayList(resolvers.size());
        resolverList.addAll(resolvers);
        Collections.sort(resolverList);
        ChainingClientInformationResolver chain = new ChainingClientInformationResolver();
        try {
            chain.setResolvers(resolverList);
            chain.setId("MultiFileResolverFor:" + resolvers.size() + ":Resources");
            chain.initialize();
            RelyingPartyClientInformationProvider result = new RelyingPartyClientInformationProvider();
            result.setEmbeddedResolver((ClientInformationResolver)chain);
            result.setApplicationContext(appContext);
            result.initialize();
            return result;
        }
        catch (ComponentInitializationException | ResolverException e) {
            throw new ServiceException("Chaining constructor create failed", (Exception)e);
        }
    }
}

