/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.spring.relyingparty.metadata.filter.impl;

import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import net.shibboleth.oidc.metadata.impl.ClientInformationNodeProcessor;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.slf4j.Logger;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class ClientInformationParser
extends AbstractSingleBeanDefinitionParser {
    @Nonnull
    public static final QName TYPE_NAME = new QName("urn:mace:shibboleth:2.0:metadata:oidc", "ClientInformation");
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ClientInformationParser.class);

    protected Class<?> getBeanClass(@Nonnull Element element) {
        return ClientInformationNodeProcessor.class;
    }

    protected void doParse(@Nonnull Element element, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        super.doParse(element, parserContext, builder);
        if (element.hasAttributeNS(null, "keyInfoProvidersRef")) {
            String trimmed = StringSupport.trimOrNull((String)element.getAttributeNS(null, "keyInfoProvidersRef"));
            if (trimmed != null) {
                builder.addConstructorArgReference(trimmed);
            }
            return;
        }
        this.log.error("No 'keyInfoProvidersRef' attribute defined!");
    }

    protected boolean shouldGenerateId() {
        return true;
    }
}

