/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.policy.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.metadata.policy.MetadataPolicy;
import net.shibboleth.oidc.metadata.policy.impl.CustomMetadataPolicyOperator;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.ConstraintViolationException;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class BeanMetadataPolicyOperator
implements CustomMetadataPolicyOperator,
ApplicationContextAware {
    public static final String BEAN_OPERATOR_NAME = "bean";
    private ApplicationContext applicationContext;

    @Override
    public boolean validate(@Nonnull MetadataPolicy policy) {
        try {
            CustomMetadataPolicyOperator operator = this.fetchPolicyOperatorBean(policy);
            return operator.validate(policy);
        }
        catch (ConstraintViolationException e) {
            return false;
        }
    }

    @Override
    public Object apply(@Nullable Object inputValue, @Nonnull MetadataPolicy policy) throws ConstraintViolationException {
        CustomMetadataPolicyOperator operator = this.fetchPolicyOperatorBean(policy);
        return operator.apply(inputValue, policy);
    }

    @Nonnull
    protected CustomMetadataPolicyOperator fetchPolicyOperatorBean(@Nonnull MetadataPolicy policy) throws ConstraintViolationException {
        Constraint.isNotNull((Object)policy, (String)"metadata policy cannot be null");
        Object rawBeanId = policy.getCustomOperators().get(BEAN_OPERATOR_NAME);
        if (rawBeanId instanceof String) {
            String beanId = (String)rawBeanId;
            try {
                return (CustomMetadataPolicyOperator)this.applicationContext.getBean(beanId, CustomMetadataPolicyOperator.class);
            }
            catch (BeansException e) {
                throw new ConstraintViolationException("Could not wire a compatible bean " + beanId);
            }
        }
        throw new ConstraintViolationException("Could not parse the bean name from policy");
    }

    public void setApplicationContext(@Nonnull ApplicationContext context) throws BeansException {
        this.applicationContext = context;
    }
}

