/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.keyinfo.ext.impl.provider;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.jwk.AsymmetricJWK;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.KeyType;
import java.security.PublicKey;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.saml.xmlobject.JwksData;
import net.shibboleth.oidc.security.CredentialConversionUtil;
import net.shibboleth.oidc.security.credential.BasicJWKCredential;
import net.shibboleth.shared.codec.Base64Support;
import net.shibboleth.shared.codec.DecodingException;
import net.shibboleth.shared.collection.LazySet;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.resolver.CriteriaSet;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.KeyInfoCredentialContext;
import org.opensaml.xmlsec.keyinfo.impl.KeyInfoResolutionContext;
import org.opensaml.xmlsec.keyinfo.impl.provider.AbstractKeyInfoProvider;
import org.slf4j.Logger;

public class InlineJwksProvider
extends AbstractKeyInfoProvider {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(InlineJwksProvider.class);

    @Nullable
    public Collection<Credential> process(@Nonnull KeyInfoCredentialResolver resolver, @Nonnull XMLObject keyInfoChild, @Nullable CriteriaSet criteriaSet, @Nonnull KeyInfoResolutionContext kiContext) throws SecurityException {
        String data;
        JwksData jwksData = this.getJwksData(keyInfoChild);
        if (jwksData == null || StringSupport.trimOrNull((String)jwksData.getValue()) == null) {
            return null;
        }
        String input = jwksData.getValue();
        assert (input != null);
        try {
            data = new String(Base64Support.decode((String)input));
        }
        catch (DecodingException e) {
            this.log.error("Could not decode the JWKS data", (Throwable)e);
            return null;
        }
        List<JWK> jwks = this.parseJWKs(data);
        if (jwks == null) {
            return null;
        }
        LazySet credentials = new LazySet();
        for (JWK jwk : jwks) {
            credentials.add((Object)this.buildCredential(jwk, kiContext));
        }
        return credentials;
    }

    @Nonnull
    protected BasicJWKCredential buildCredential(@Nonnull JWK jwk, @Nonnull KeyInfoResolutionContext kiContext) {
        BasicJWKCredential credential;
        block10: {
            credential = new BasicJWKCredential();
            if ((jwk.getKeyType() == KeyType.EC || jwk.getKeyType() == KeyType.RSA) && jwk instanceof AsymmetricJWK) {
                AsymmetricJWK asymmetricJwk = (AsymmetricJWK)jwk;
                try {
                    PublicKey publicKey = asymmetricJwk.toPublicKey();
                    if (publicKey != null) {
                        credential.setPublicKey(publicKey);
                        break block10;
                    }
                    this.log.warn("Could not parse public key from JWK: public key is null");
                }
                catch (JOSEException e) {
                    this.log.warn("Could not parse public key from JWK", (Throwable)e);
                }
            } else {
                this.log.warn("Unsupported key type {} found from JWK", (Object)jwk.getKeyType());
            }
        }
        if (jwk.getKeyID() != null) {
            credential.getKeyNames().add(jwk.getKeyID());
            credential.setKid(jwk.getKeyID());
        } else {
            credential.getKeyNames().addAll(kiContext.getKeyNames());
        }
        if (jwk.getKeyUse() != null) {
            credential.setUsageType(CredentialConversionUtil.getUsageType((JWK)jwk));
        } else {
            KeyInfoCredentialContext credContext = this.buildCredentialContext(kiContext);
            if (credContext != null) {
                credential.getCredentialContextSet().add((Object)credContext);
            }
        }
        return credential;
    }

    @Nullable
    protected List<JWK> parseJWKs(@Nullable String input) {
        JWKSet jwkSet = this.parseJWKSet(input);
        if (jwkSet != null) {
            return jwkSet.getKeys();
        }
        JWK jwk = this.parseJWK(input);
        if (jwk != null) {
            return Arrays.asList(jwk);
        }
        this.log.warn("Could not parse neither JWKSet nor JWK from the given input {}", (Object)input);
        return null;
    }

    @Nullable
    protected JWKSet parseJWKSet(@Nullable String input) {
        try {
            return JWKSet.parse((String)input);
        }
        catch (ParseException e) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Could not parse JWKSet from the given input", (Throwable)e);
            } else {
                this.log.debug("Could not parse JWKSet from the given input: {}", (Object)e.getMessage());
            }
            return null;
        }
    }

    @Nullable
    protected JWK parseJWK(@Nullable String input) {
        try {
            return JWK.parse((String)input);
        }
        catch (ParseException e) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Could not parse JWK from the given input", (Throwable)e);
            } else {
                this.log.debug("Could not parse JWK from the given input: {}", (Object)e.getMessage());
            }
            return null;
        }
    }

    public boolean handles(@Nonnull XMLObject keyInfoChild) {
        return this.getJwksData(keyInfoChild) != null;
    }

    @Nullable
    protected JwksData getJwksData(@Nonnull XMLObject xmlObject) {
        if (xmlObject instanceof JwksData) {
            return (JwksData)xmlObject;
        }
        return null;
    }
}

