/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.impl;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minidev.json.JSONObject;
import net.shibboleth.oidc.metadata.ClientInformationResolver;
import net.shibboleth.oidc.metadata.criterion.ClientIDCriterion;
import net.shibboleth.oidc.metadata.impl.BaseStorageServiceClientInformationComponent;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.storage.StorageRecord;
import org.slf4j.Logger;

public class StorageServiceClientInformationResolver
extends BaseStorageServiceClientInformationComponent
implements ClientInformationResolver {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(StorageServiceClientInformationResolver.class);

    @Nonnull
    public Iterable<OIDCClientInformation> resolve(@Nullable CriteriaSet criteria) throws ResolverException {
        ClientIDCriterion clientIdCriterion;
        this.ifNotInitializedThrowUninitializedComponentException();
        this.ifDestroyedThrowDestroyedComponentException();
        ClientIDCriterion clientIDCriterion = clientIdCriterion = criteria != null ? (ClientIDCriterion)criteria.get(ClientIDCriterion.class) : null;
        if (clientIdCriterion == null || clientIdCriterion.getClientID() == null) {
            this.log.info("No client ID criteria found, returning empty set.");
            return CollectionSupport.emptyList();
        }
        String clientId = clientIdCriterion.getClientID().getValue();
        assert (clientId != null);
        ArrayList<OIDCClientInformation> result = new ArrayList<OIDCClientInformation>();
        try {
            StorageRecord record = this.getStorageService().read("oidcClientInformation", clientId);
            if (record == null) {
                this.log.debug("Could not find any records with clientId {}", (Object)clientId);
            } else {
                OIDCClientInformation clientInformation = OIDCClientInformation.parse((JSONObject)JSONObjectUtils.parse((String)record.getValue()));
                this.log.debug("Found a record with clientId {}", (Object)clientId);
                result.add(clientInformation);
            }
        }
        catch (ParseException | IOException e) {
            this.log.error("Could not read the storage data", e);
        }
        return result;
    }

    @Nullable
    public OIDCClientInformation resolveSingle(@Nullable CriteriaSet criteria) throws ResolverException {
        Iterator<OIDCClientInformation> iterator;
        Iterable<OIDCClientInformation> iterable = this.resolve(criteria);
        if (iterable != null && (iterator = iterable.iterator()) != null && iterator.hasNext()) {
            return iterator.next();
        }
        this.log.warn("Could not find any clients with the given criteria");
        return null;
    }
}

