/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.impl;

import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.metadata.ClientInformationResolver;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import net.shibboleth.shared.service.ReloadableService;
import net.shibboleth.shared.service.ServiceException;
import net.shibboleth.shared.service.ServiceableComponent;
import org.slf4j.Logger;

public class ReloadingRelyingPartyClientInformationProvider
extends AbstractIdentifiableInitializableComponent
implements ClientInformationResolver {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ReloadingRelyingPartyClientInformationProvider.class);
    private final ReloadableService<ClientInformationResolver> service;

    public ReloadingRelyingPartyClientInformationProvider(@Nonnull ReloadableService<ClientInformationResolver> resolverService) {
        this.service = (ReloadableService)Constraint.isNotNull(resolverService, (String)"ClientInformationResolver Service cannot be null");
    }

    @Nonnull
    public Iterable<OIDCClientInformation> resolve(@Nullable CriteriaSet criteria) throws ResolverException {
        block10: {
            Iterable iterable;
            block9: {
                this.ifNotInitializedThrowUninitializedComponentException();
                ServiceableComponent component = this.service.getServiceableComponent();
                try {
                    ClientInformationResolver resolver = (ClientInformationResolver)component.getComponent();
                    iterable = resolver.resolve((Object)criteria);
                    if (component == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (component != null) {
                            try {
                                component.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (ResolverException e) {
                        this.log.error("RelyingPartyClientInformationProvider '{}': Error during resolution", (Object)this.getId(), (Object)e);
                        break block10;
                    }
                    catch (ServiceException e) {
                        this.log.error("RelyingPartyClientInformationProvider '{}': Error accessing underlying source: Invalid configuration.", (Object)this.getId());
                    }
                }
                component.close();
            }
            return iterable;
        }
        return CollectionSupport.emptySet();
    }

    @Nullable
    public OIDCClientInformation resolveSingle(@Nullable CriteriaSet criteria) throws ResolverException {
        block10: {
            OIDCClientInformation oIDCClientInformation;
            block9: {
                this.ifNotInitializedThrowUninitializedComponentException();
                ServiceableComponent component = this.service.getServiceableComponent();
                try {
                    ClientInformationResolver resolver = (ClientInformationResolver)component.getComponent();
                    oIDCClientInformation = (OIDCClientInformation)resolver.resolveSingle((Object)criteria);
                    if (component == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (component != null) {
                            try {
                                component.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (ResolverException e) {
                        this.log.error("RelyingPartyResolver '{}': Error during resolution", (Object)this.getId(), (Object)e);
                        break block10;
                    }
                    catch (ServiceException e) {
                        this.log.error("RelyingPartyClientInformationProvider '{}': Error accessing underlying source: Invalid configuration.", (Object)this.getId());
                    }
                }
                component.close();
            }
            return oIDCClientInformation;
        }
        return null;
    }
}

