/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.impl;

import com.google.common.net.MediaType;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.io.IOException;
import java.util.Set;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.oidc.metadata.criterion.IssuerIDCriterion;
import net.shibboleth.oidc.metadata.impl.AbstractDynamicHTTPFetchingStrategy;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.net.MediaTypeSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.MDC;

@ThreadSafe
public class HTTPProviderConfigurationFetchingStrategy
extends AbstractDynamicHTTPFetchingStrategy<OIDCProviderMetadata> {
    @Nonnull
    private static final MediaType CONTENT_TYPE = MediaType.JSON_UTF_8;
    @Nonnull
    @NotEmpty
    private static final String DEFAULT_OPENID_PROVIDER_WELL_KNOWN_PATH = "/.well-known/openid-configuration";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(HTTPProviderConfigurationFetchingStrategy.class);
    @Nonnull
    @NotEmpty
    private String wellKnownPath = "/.well-known/openid-configuration";
    @Nonnull
    private BiFunction<Issuer, String, String> wellKnownLocationCompositionStrategy = new DefaultWellKnownPathCompositionStrategy();

    protected HTTPProviderConfigurationFetchingStrategy(@Nonnull HttpClient client, @Nonnull HttpClientResponseHandler<OIDCProviderMetadata> handler) {
        super(client, handler);
    }

    public void setWellKnownPath(@Nonnull @NotEmpty String path) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.ifDestroyedThrowDestroyedComponentException();
        this.wellKnownPath = Constraint.isNotEmpty((String)path, (String)"Well-know path can not be null");
    }

    public void setWellKnownLocationCompositionStrategy(@Nullable BiFunction<Issuer, String, String> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.ifDestroyedThrowDestroyedComponentException();
        if (strategy != null) {
            this.wellKnownLocationCompositionStrategy = strategy;
        }
    }

    @Override
    protected String buildRequestURL(@Nullable CriteriaSet criteria) {
        IssuerIDCriterion issuerCrit;
        IssuerIDCriterion issuerIDCriterion = issuerCrit = criteria != null ? (IssuerIDCriterion)criteria.get(IssuerIDCriterion.class) : null;
        if (issuerCrit != null) {
            String url = this.wellKnownLocationCompositionStrategy.apply(issuerCrit.getIssuerID(), this.wellKnownPath);
            this.log.debug("URL generated by request builder was: {}", (Object)url);
            return url;
        }
        return null;
    }

    @Immutable
    @ThreadSafe
    private static final class DefaultWellKnownPathCompositionStrategy
    implements BiFunction<Issuer, String, String> {
        private DefaultWellKnownPathCompositionStrategy() {
        }

        @Override
        @Nullable
        public String apply(@Nullable Issuer issuer, @Nullable @NotEmpty String wellKnownPath) {
            if (issuer == null) {
                return null;
            }
            String normalizedIssuer = StringUtils.removeEnd((String)issuer.getValue(), (String)"/");
            StringBuilder builder = new StringBuilder();
            builder.append(normalizedIssuer).append(wellKnownPath);
            return builder.toString();
        }
    }

    @Immutable
    @ThreadSafe
    public static final class OIDCProviderMetadataResponseHandler
    implements HttpClientResponseHandler<OIDCProviderMetadata> {
        @Nonnull
        private final Logger log = LoggerFactory.getLogger(OIDCProviderMetadataResponseHandler.class);

        @Nullable
        public OIDCProviderMetadata handleResponse(ClassicHttpResponse response) throws IOException {
            int httpStatusCode = response.getCode();
            String currentRequestURI = MDC.get((String)AbstractDynamicHTTPFetchingStrategy.MDC_ATTRIB_CURRENT_REQUEST_URI);
            if (httpStatusCode == 304) {
                this.log.debug("Metadata document from '{}' has not changed since last retrieval", (Object)currentRequestURI);
                return null;
            }
            if (httpStatusCode != 200) {
                this.log.warn("Non-ok status code '{}' returned from remote metadata source: {}", (Object)httpStatusCode, (Object)currentRequestURI);
                return null;
            }
            try {
                this.validateHttpResponse(response);
            }
            catch (ResolverException e) {
                this.log.error("Problem validating dynamic OIDC metadata HTTP response", (Throwable)e);
                return null;
            }
            try {
                String jsonDocument = EntityUtils.toString((HttpEntity)response.getEntity());
                OIDCProviderMetadata metadata = OIDCProviderMetadata.parse((String)jsonDocument);
                assert (metadata != null);
                if (!this.metadataValid(metadata, currentRequestURI)) {
                    return null;
                }
                return metadata;
            }
            catch (Exception e) {
                this.log.error("Error parsing HTTP response stream", (Throwable)e);
                return null;
            }
        }

        private final boolean metadataValid(@Nonnull OIDCProviderMetadata metadata, @Nullable String issuerURL) {
            if (issuerURL == null || metadata.getIssuer() == null) {
                return false;
            }
            boolean valid = issuerURL.startsWith(metadata.getIssuer().getValue());
            if (!valid) {
                this.log.warn("OIDC metadata was not valid, Issuer in metadata did not match Issuer URL. Issuer was '{}', IssuerURL was '{}'", (Object)metadata.getIssuer().getValue(), (Object)issuerURL);
                return false;
            }
            return true;
        }

        protected void validateHttpResponse(@Nonnull ClassicHttpResponse response) throws ResolverException {
            String contentTypeValue = response.getEntity().getContentType();
            this.log.debug("Saw raw Content-Type from response header '{}'", (Object)contentTypeValue);
            if (!MediaTypeSupport.validateContentType((String)contentTypeValue, (Set)CollectionSupport.setOf((Object)CONTENT_TYPE), (boolean)true, (boolean)false)) {
                throw new ResolverException("HTTP response specified an unsupported Content-Type MIME type: " + contentTypeValue);
            }
        }
    }
}

