/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.impl;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.oidc.metadata.DynamicBackingStore;
import net.shibboleth.oidc.metadata.MetadataManagementData;
import net.shibboleth.oidc.metadata.impl.AbstractBackingStore;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;

@ThreadSafe
public class DefaultDynamicBackingStore<I, T>
extends AbstractBackingStore<I, T>
implements DynamicBackingStore<I, T> {
    @Nonnull
    private final Map<I, MetadataManagementData<I>> mgmtDataMap = new ConcurrentHashMap<I, MetadataManagementData<I>>();

    @Nonnull
    public MetadataManagementData<I> computeManagementDataIfAbsent(@Nonnull I identifier, @Nonnull Function<I, MetadataManagementData<I>> mappingFunction) {
        Constraint.isNotNull(identifier, (String)"identifier cannot be null");
        Constraint.isNotNull(mappingFunction, (String)"Mapping function cannot be null");
        MetadataManagementData<I> data = this.mgmtDataMap.computeIfAbsent(identifier, mappingFunction);
        assert (data != null);
        return data;
    }

    @Nullable
    public MetadataManagementData<I> getManagementData(@Nonnull I identifier) {
        Constraint.isNotNull(identifier, (String)"identifier may not be null");
        return this.mgmtDataMap.get(identifier);
    }

    public synchronized void removeManagementData(@Nonnull I identifier) {
        Constraint.isNotNull(identifier, (String)"Identifier may not be null");
        this.mgmtDataMap.remove(identifier);
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    public synchronized Set<I> getManagementDataIdentifiers() {
        Set<I> keySet = this.mgmtDataMap.keySet();
        return keySet == null ? CollectionSupport.emptySet() : CollectionSupport.copyToSet(keySet);
    }
}

