/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.impl;

import com.nimbusds.oauth2.sdk.id.Identifier;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.time.Instant;
import java.util.Timer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.metadata.impl.AbstractReloadingOIDCEntityResolver;
import net.shibboleth.oidc.metadata.impl.ResolverHelper;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.ResolverException;
import org.slf4j.Logger;
import org.springframework.core.io.Resource;

public abstract class AbstractFileOIDCEntityResolver<Key extends Identifier, Value>
extends AbstractReloadingOIDCEntityResolver<Key, Value> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractFileOIDCEntityResolver.class);
    @Nonnull
    private File metadataFile;

    protected AbstractFileOIDCEntityResolver(@Nonnull Resource metadata) throws IOException {
        this.metadataFile = (File)Constraint.isNotNull((Object)metadata.getFile(), (String)"Metadata file cannot be null");
    }

    protected AbstractFileOIDCEntityResolver(@Nullable Timer backgroundTaskTimer, @Nonnull Resource metadata) throws IOException {
        super(backgroundTaskTimer);
        this.metadataFile = (File)Constraint.isNotNull((Object)metadata.getFile(), (String)"Metadata file cannot be null");
    }

    protected void setMetadataFile(@Nonnull File file) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.ifDestroyedThrowDestroyedComponentException();
        this.metadataFile = (File)Constraint.isNotNull((Object)file, (String)"Metadata file cannot be null");
    }

    @Override
    @Nonnull
    protected String getMetadataIdentifier() {
        String path = this.metadataFile.getAbsolutePath();
        if (path == null) {
            return "unknown";
        }
        return path;
    }

    protected Instant getMetadataUpdateTime() {
        return Instant.ofEpochMilli(this.metadataFile.lastModified());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected byte[] fetchMetadata() throws ResolverException {
        byte[] byArray;
        ResolverHelper.validateMetadataFile(this.metadataFile);
        Instant metadataUpdateTime = this.getMetadataUpdateTime();
        if (this.getLastRefresh() != null && this.getLastUpdate() != null && !metadataUpdateTime.isAfter(this.getLastRefresh())) return null;
        FileInputStream fileInput = new FileInputStream(this.metadataFile);
        try {
            this.log.debug("Returning the contents of {} as byte array", (Object)this.metadataFile.toPath());
            byArray = ResolverHelper.inputstreamToByteArray(fileInput);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileInput.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                String errMsg = "Unable to read metadata file " + this.metadataFile.getAbsolutePath();
                this.log.error(errMsg, (Throwable)e);
                throw new ResolverException(errMsg, (Exception)e);
            }
        }
        fileInput.close();
        return byArray;
    }
}

