/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.cache.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.time.Instant;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.oidc.metadata.cache.CacheLoadingContext;
import net.shibboleth.oidc.metadata.cache.CacheLoadingException;
import net.shibboleth.oidc.metadata.cache.LoadingStrategy;
import net.shibboleth.oidc.metadata.impl.ResolverHelper;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;
import org.springframework.core.io.Resource;

@ThreadSafe
public class DefaultFileLoadingStrategy
implements LoadingStrategy {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DefaultFileLoadingStrategy.class);
    @Nullable
    private final File metadataFile;
    @Nonnull
    @NotEmpty
    private final String metadataFileFriendlyName;

    public DefaultFileLoadingStrategy(@Nullable Resource metadata) throws IOException {
        if (metadata == null) {
            this.log.warn("File resource is null, no bytes will be returned");
            this.metadataFile = null;
            this.metadataFileFriendlyName = "No file specified";
        } else {
            this.metadataFile = metadata.getFile();
            this.metadataFileFriendlyName = metadata.getDescription();
        }
    }

    @Nullable
    private Instant getMetadataUpdateTime() {
        return this.metadataFile != null ? Instant.ofEpochMilli(this.metadataFile.lastModified()) : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public byte[] load(@Nonnull CacheLoadingContext context) throws CacheLoadingException {
        byte[] byArray;
        File mfile = this.metadataFile;
        if (mfile == null) {
            return null;
        }
        ResolverHelper.validateMetadataFile(mfile);
        Instant metadataUpdateTime = this.getMetadataUpdateTime();
        if (context.getLastRefresh() != null && context.getLastUpdate() != null && metadataUpdateTime != null && !metadataUpdateTime.isAfter(context.getLastRefresh())) return null;
        this.log.debug("Returning the contents of {} as byte array", (Object)mfile.toPath());
        FileInputStream fileInput = new FileInputStream(this.metadataFile);
        try {
            byArray = ResolverHelper.inputstreamToByteArray(fileInput);
        }
        catch (Throwable throwable) {
            try {
                try {
                    try {
                        fileInput.close();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new CacheLoadingException("Unable to read metadata file", e);
                }
            }
            catch (Exception e) {
                String errMsg = "Unable to read metadata file " + mfile.getAbsolutePath();
                this.log.error(errMsg, (Object)e.getMessage());
                throw new CacheLoadingException(errMsg, e);
            }
        }
        fileInput.close();
        return byArray;
    }

    @Nonnull
    public String getSourceIdentifier() {
        return this.metadataFileFriendlyName;
    }
}

