/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.attribute.transcoding;

import com.google.common.base.Strings;
import com.nimbusds.openid.connect.sdk.claims.ClaimRequirement;
import com.nimbusds.openid.connect.sdk.claims.ClaimsSetRequest;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.shibboleth.idp.attribute.AttributeDecodingException;
import net.shibboleth.idp.attribute.AttributeEncodingException;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.IdPRequestedAttribute;
import net.shibboleth.idp.attribute.transcoding.AbstractAttributeTranscoder;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.oidc.attribute.transcoding.OIDCAttributeTranscoder;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public abstract class AbstractOIDCAttributeTranscoder
extends AbstractAttributeTranscoder<JSONObject>
implements OIDCAttributeTranscoder {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractOIDCAttributeTranscoder.class);
    @Nullable
    private Function<ProfileRequestContext, Set<String>> nameFromMetadataLookupStrategy;

    @Nonnull
    public Class<JSONObject> getEncodedType() {
        return JSONObject.class;
    }

    public void setNameFromMetadataLookupStrategy(@Nullable Function<ProfileRequestContext, Set<String>> strategy) {
        this.checkSetterPreconditions();
        this.nameFromMetadataLookupStrategy = strategy;
    }

    @Nullable
    public String getEncodedName(@Nonnull TranscodingRule rule) {
        String name = (String)rule.getOrDefault("oidc.name", String.class, (Object)((String)rule.get("id", String.class)));
        if (name != null) {
            return "OIDC:" + name;
        }
        return null;
    }

    @Nullable
    public JSONObject doEncode(@Nullable ProfileRequestContext profileRequestContext, @Nonnull IdPAttribute attribute, @Nonnull Class<? extends JSONObject> to, @Nonnull TranscodingRule rule) throws AttributeEncodingException {
        String attributeId = attribute.getId();
        this.log.trace("Beginning to encode attribute {}", (Object)attributeId);
        Object claimValues = this.encodeValues(profileRequestContext, attribute, rule);
        if (claimValues instanceof JSONArray) {
            this.log.trace("Encoded {} value(s) for attribute {}", (Object)((JSONArray)claimValues).size(), (Object)attributeId);
        } else {
            this.log.trace("Encoded {} value(s) for attribute {}", (Object)(claimValues != null ? 1 : 0), (Object)attributeId);
        }
        return this.buildClaim(profileRequestContext, attribute, rule, claimValues);
    }

    @Nonnull
    protected JSONObject buildClaim(@Nullable ProfileRequestContext profileRequestContext, @Nullable IdPAttribute attribute, @Nonnull TranscodingRule rule, @Nullable Object claimValues) throws AttributeEncodingException {
        if (claimValues == null) {
            throw new AttributeEncodingException("Unable to build OIDC claim with no value(s)");
        }
        String name = this.getEncodedName(profileRequestContext, attribute, rule);
        JSONObject claim = new JSONObject();
        claim.put((Object)name, claimValues);
        return claim;
    }

    protected String getEncodedName(@Nullable ProfileRequestContext profileRequestContext, @Nullable IdPAttribute attribute, @Nonnull TranscodingRule rule) throws AttributeEncodingException {
        String name;
        Boolean useMetadata = (Boolean)rule.getOrDefault("oidc.nameFromSamlMetadata", Boolean.class, (Object)false);
        if (useMetadata != null && useMetadata.booleanValue()) {
            String id;
            String string = id = attribute != null ? attribute.getId() : (String)rule.get("id", String.class);
            if (id == null) {
                this.log.warn("Rule specified {} but no attribute ID available", (Object)"oidc.nameFromSamlMetadata");
            } else {
                String tagValue = this.getNameFromMetadata(profileRequestContext, id);
                if (tagValue != null) {
                    int lastSpace = tagValue.lastIndexOf(32);
                    String name2 = lastSpace < 0 ? StringSupport.trimOrNull((String)tagValue) : StringSupport.trimOrNull((String)tagValue.substring(0, lastSpace));
                    if (name2 != null) {
                        return name2;
                    }
                    this.log.warn("Metadata tag {}, value {}, was not in the expected form", (Object)"http://shibboleth.net/ns/attributes/naming/oidc", (Object)tagValue);
                }
            }
        }
        if (Strings.isNullOrEmpty((String)(name = (String)rule.getOrDefault("oidc.name", String.class, (Object)(attribute != null ? attribute.getId() : null))))) {
            throw new AttributeEncodingException("Required transcoder property 'oidc.name' not found");
        }
        return name;
    }

    @Nullable
    protected abstract Object encodeValues(@Nullable ProfileRequestContext var1, @Nonnull IdPAttribute var2, @Nonnull TranscodingRule var3) throws AttributeEncodingException;

    @Nullable
    public IdPAttribute doDecode(@Nullable ProfileRequestContext profileRequestContext, @Nonnull JSONObject input, @Nonnull TranscodingRule rule) throws AttributeDecodingException {
        String attributeName = (String)rule.getOrDefault("oidc.name", String.class, (Object)((String)rule.get("id", String.class)));
        this.log.trace("Beginning to decode claim '{}'", (Object)attributeName);
        Object inputToDecode = input.get((Object)attributeName);
        if (inputToDecode == null) {
            this.log.debug("Skipping null value(s) of attribute '{}'", (Object)attributeName);
        } else {
            List<IdPAttributeValue> decodedValues = this.decodeValues(profileRequestContext, inputToDecode, rule);
            if (decodedValues.isEmpty()) {
                this.log.trace("Unable to decode value(s) of attribute '{}'", (Object)attributeName);
            } else {
                this.log.trace("Decoded {} value(s) for attribute '{}'", (Object)decodedValues.size(), (Object)attributeName);
                return this.buildIdPAttribute(profileRequestContext, input, rule, decodedValues);
            }
        }
        return this.buildIdPAttribute(profileRequestContext, input, rule, CollectionSupport.emptyList());
    }

    @Nonnull
    protected IdPAttribute buildIdPAttribute(@Nullable ProfileRequestContext profileRequestContext, @Nonnull JSONObject claim, @Nonnull TranscodingRule rule, @Nonnull List<IdPAttributeValue> attributeValues) throws AttributeDecodingException {
        String id = (String)rule.get("id", String.class);
        if (Strings.isNullOrEmpty((String)id)) {
            throw new AttributeDecodingException("Required transcoder property 'id' not found");
        }
        assert (id != null);
        String name = (String)rule.getOrDefault("oidc.name", String.class, (Object)id);
        Object claimValue = claim.get((Object)name);
        if (claimValue instanceof ClaimsSetRequest.Entry) {
            IdPRequestedAttribute idpAttribute = new IdPRequestedAttribute(id);
            idpAttribute.setRequired(ClaimRequirement.ESSENTIAL.equals((Object)((ClaimsSetRequest.Entry)claimValue).getClaimRequirement()));
            idpAttribute.setValues(attributeValues);
            return idpAttribute;
        }
        IdPAttribute idpAttribute = new IdPAttribute(id);
        idpAttribute.setValues(attributeValues);
        return idpAttribute;
    }

    @Nonnull
    protected abstract List<IdPAttributeValue> decodeValues(@Nullable ProfileRequestContext var1, @Nonnull Object var2, @Nonnull TranscodingRule var3) throws AttributeDecodingException;

    @Nullable
    protected String getNameFromMetadata(@Nullable ProfileRequestContext profileRequestContext, @Nonnull String attributeId) {
        if (this.nameFromMetadataLookupStrategy != null) {
            Set<String> tagValues = this.nameFromMetadataLookupStrategy.apply(profileRequestContext);
            if (tagValues != null) {
                for (String tagValue : tagValues) {
                    String ret;
                    if (tagValue == null || !tagValue.startsWith(attributeId + " ") || (ret = tagValue.substring(attributeId.length() + 1)).isEmpty()) continue;
                    return ret;
                }
                this.log.debug("No applicable tag value found for metadata-driven naming for {}", (Object)attributeId);
            } else {
                this.log.debug("No tag values found for metadata-driven naming for {}", (Object)attributeId);
            }
        }
        return null;
    }

    public static class NamingFunction
    implements Function<JSONObject, String> {
        @Override
        @Nullable
        public String apply(@Nullable JSONObject input) {
            if (input == null) {
                return null;
            }
            Set keys = input.keySet();
            if (keys.size() != 1) {
                return null;
            }
            return "OIDC:" + (String)keys.iterator().next();
        }
    }
}

