/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.jwt.claims.impl;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.openid.connect.sdk.OIDCClaimsRequest;
import com.nimbusds.openid.connect.sdk.claims.ClaimRequirement;
import com.nimbusds.openid.connect.sdk.claims.ClaimsSetRequest;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.oidc.profile.core.OIDCAuthenticationRequest;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;

public class RequestedEssentialACRClaimsLookupStrategy
implements BiFunction<ProfileRequestContext, JWTClaimsSet, List<String>> {
    @Nonnull
    private final Function<ProfileRequestContext, OIDCAuthenticationRequest> authenticationRequestLookupStrategy;

    public RequestedEssentialACRClaimsLookupStrategy(@ParameterName(name="authenticationRequestLookupStrategy") @Nonnull Function<ProfileRequestContext, OIDCAuthenticationRequest> strategy) {
        this.authenticationRequestLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"authenticationRequestLookupStrategy can not be null");
    }

    @Override
    @Nonnull
    public List<String> apply(ProfileRequestContext prc, JWTClaimsSet claims) {
        OIDCAuthenticationRequest authRequest = this.authenticationRequestLookupStrategy.apply(prc);
        if (authRequest == null) {
            return CollectionSupport.emptyList();
        }
        OIDCClaimsRequest requestedClaims = authRequest.getRequestedClaims();
        if (requestedClaims != null) {
            ClaimsSetRequest idTokenRequested = requestedClaims.getIDTokenClaimsRequest();
            if (idTokenRequested == null) {
                return CollectionSupport.emptyList();
            }
            ClaimsSetRequest.Entry acrs = idTokenRequested.get("acr");
            if (acrs != null && acrs.getClaimRequirement() == ClaimRequirement.ESSENTIAL) {
                String valueAsString = acrs.getValueAsString();
                List valuesAsListOfStrings = acrs.getValuesAsListOfStrings();
                if (valueAsString != null) {
                    return CollectionSupport.listOf((Object)valueAsString);
                }
                if (valuesAsListOfStrings != null) {
                    return CollectionSupport.copyToList((Collection)valuesAsListOfStrings);
                }
            }
        }
        return CollectionSupport.emptyList();
    }
}

