/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.jwt.claims.impl;

import com.nimbusds.jwt.JWTClaimsSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.jwt.claims.AbstractClaimsValidator;
import net.shibboleth.oidc.jwt.claims.JWTValidationException;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;

@ThreadSafeAfterInit
public class ProhibitedClaimsValidator
extends AbstractClaimsValidator {
    @Nonnull
    @NonnullElements
    private Set<String> prohibitedClaims = CollectionSupport.emptySet();

    public void setProhibitedClaims(@Nullable Collection<String> claims) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.prohibitedClaims = claims != null ? CollectionSupport.copyToSet((Collection)StringSupport.normalizeStringCollection(claims)) : CollectionSupport.emptySet();
    }

    public void doValidate(@Nonnull JWTClaimsSet claims, @Nonnull ProfileRequestContext context) throws JWTValidationException {
        HashSet<String> presentProhibitedClaims = new HashSet<String>();
        for (String prohibited : this.prohibitedClaims) {
            if (claims.getClaims().containsKey(prohibited)) {
                presentProhibitedClaims.add(prohibited);
            }
            if (presentProhibitedClaims.isEmpty()) continue;
            throw new JWTValidationException("JWT has prohibited claims: " + String.valueOf(presentProhibitedClaims));
        }
    }
}

