/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.jwt.claims.impl;

import com.nimbusds.jwt.JWTClaimsSet;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.jwt.claims.AbstractClaimsValidator;
import net.shibboleth.oidc.jwt.claims.JWTValidationException;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.storage.ReplayCache;

public class JWTIdentifierClaimsValidator
extends AbstractClaimsValidator {
    @NonnullAfterInit
    private ReplayCache replayCache;
    @Nonnull
    private Duration clockSkew;
    @Nullable
    private Duration replayCacheRecordLifetime;
    @Nullable
    private Duration maxReplayCacheRecordLifetime;
    @Nullable
    private Function<String, String> replayCacheKeyCalculationStrategy;

    public JWTIdentifierClaimsValidator() {
        Duration oneMinute = Duration.ofMinutes(1L);
        assert (oneMinute != null);
        this.clockSkew = oneMinute;
        this.replayCacheRecordLifetime = null;
        this.maxReplayCacheRecordLifetime = null;
        this.replayCacheKeyCalculationStrategy = null;
    }

    public void setReplayCache(@Nonnull ReplayCache cache) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.replayCache = (ReplayCache)Constraint.isNotNull((Object)cache, (String)"ReplayCache cannot be null");
    }

    public void setClockSkew(@Nonnull Duration skew) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.clockSkew = (Duration)Constraint.isNotNull((Object)skew, (String)"Clock skew cannot be null");
    }

    public void setReplayCacheRecordLifetime(@Nullable Duration lifetime) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.replayCacheRecordLifetime = lifetime;
    }

    public void setMaxReplayCacheRecordLifetime(@Nullable Duration lifetime) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.maxReplayCacheRecordLifetime = lifetime;
    }

    public void setReplayCacheKeyCalculationStrategy(@Nullable Function<String, String> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.replayCacheKeyCalculationStrategy = strategy;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.replayCache == null) {
            throw new ComponentInitializationException("ReplayCache can not be null");
        }
    }

    protected void doValidate(@Nonnull JWTClaimsSet claims, @Nullable ProfileRequestContext context) throws JWTValidationException {
        String replayCacheKey;
        Instant expiry;
        Date exp = claims.getExpirationTime();
        if (exp == null) {
            if (this.replayCacheRecordLifetime == null) {
                throw new JWTValidationException("The claims set is missing required expiration time (exp)");
            }
            expiry = Instant.now().plus(this.replayCacheRecordLifetime);
        } else {
            Instant maxExpiry;
            Instant claimExpiry = exp.toInstant().plus(this.clockSkew);
            expiry = this.maxReplayCacheRecordLifetime == null ? claimExpiry : ((maxExpiry = Instant.now().plus(this.maxReplayCacheRecordLifetime).plus(this.clockSkew)).isBefore(claimExpiry) ? maxExpiry : claimExpiry);
        }
        String jti = claims.getJWTID();
        if (StringSupport.trimOrNull((String)jti) == null) {
            throw new JWTValidationException("The claims set is missing required JWT identifier (jti)");
        }
        if (this.replayCacheKeyCalculationStrategy != null) {
            replayCacheKey = StringSupport.trimOrNull((String)this.replayCacheKeyCalculationStrategy.apply(jti));
            if (replayCacheKey == null) {
                throw new JWTValidationException("The replay cache key calculation strategy returned null");
            }
        } else {
            replayCacheKey = jti;
        }
        String className = ((Object)((Object)this)).getClass().getName();
        assert (className != null && replayCacheKey != null && expiry != null);
        if (!this.replayCache.check(className, replayCacheKey, expiry)) {
            throw new JWTValidationException("Replay detected for key '" + replayCacheKey + "'");
        }
    }
}

