/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.jwt.claims.impl;

import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;

public enum IDTokenClaims {
    AUTHENTICATION_TIME("auth_time"),
    NONCE("nonce"),
    AUTHENTICATION_CONTEXT_CLASS_REFERENCE("acr"),
    AUTHENTICATION_METHODS_REFERENCES("amr"),
    AUTHORIZED_PARTY("azp");

    @Nonnull
    @NotEmpty
    private final String claimName;

    private IDTokenClaims(String name) {
        this.claimName = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"Claim name can not be null or empty");
    }

    @Nonnull
    public String getClaimName() {
        return this.claimName;
    }
}

