/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.jwt.claims.impl;

import com.nimbusds.jwt.JWTClaimsSet;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import javax.annotation.Nonnull;
import net.shibboleth.oidc.jwt.claims.AbstractClaimsValidator;
import net.shibboleth.oidc.jwt.claims.JWTValidationException;
import net.shibboleth.shared.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;

@ThreadSafeAfterInit
public class ExpiryClaimsValidator
extends AbstractClaimsValidator {
    @Nonnull
    private Duration clockSkew = Duration.ofSeconds(60L);

    public void setClockSkew(@Nonnull Duration skew) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.clockSkew = (Duration)Constraint.isNotNull((Object)skew, (String)"Clock skew cannot be null");
    }

    public void doValidate(@Nonnull JWTClaimsSet claims, @Nonnull ProfileRequestContext context) throws JWTValidationException {
        Instant expInstant;
        Instant expirationPlusSkew;
        Instant now = Instant.now();
        Date exp = claims.getExpirationTime();
        if (exp != null && now.isAfter(expirationPlusSkew = (expInstant = exp.toInstant()).plus(this.clockSkew))) {
            throw new JWTValidationException("Expired JWT");
        }
    }
}

