/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.jwt.claims.impl;

import com.nimbusds.jwt.JWTClaimsSet;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;

@ThreadSafe
public class ClaimExistsActivationCondition
implements BiPredicate<ProfileRequestContext, JWTClaimsSet> {
    @Nonnull
    @NotEmpty
    private final String claimToCheck;

    public ClaimExistsActivationCondition(@Nonnull @ParameterName(name="claimToCheck") @NotEmpty String claimName) {
        this.claimToCheck = Constraint.isNotEmpty((String)claimName, (String)"Claim to check can not be empty or null");
    }

    @Override
    public boolean test(@Nullable ProfileRequestContext context, @Nullable JWTClaimsSet claims) {
        return claims != null && claims.getClaim(this.claimToCheck) != null;
    }
}

