/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.jwt.claims.impl;

import com.nimbusds.jwt.JWTClaimsSet;
import java.text.ParseException;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.shibboleth.oidc.jwt.claims.AbstractClaimsValidator;
import net.shibboleth.oidc.jwt.claims.JWTValidationException;
import net.shibboleth.oidc.security.jwt.claims.impl.IDTokenClaims;
import net.shibboleth.shared.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

@ThreadSafeAfterInit
public class AuthenticationTimeClaimsValidator
extends AbstractClaimsValidator {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AuthenticationTimeClaimsValidator.class);
    @Nonnull
    private Function<ProfileRequestContext, Duration> authnLifetimeLookupStrategy = prc -> Duration.ofSeconds(60L);
    @Nonnull
    private Function<ProfileRequestContext, Instant> authnRequestTimeLookupStrategy;
    @Nonnull
    private Duration clockSkew = Duration.ofSeconds(60L);
    @Nonnull
    private Predicate<ProfileRequestContext> requested;

    public AuthenticationTimeClaimsValidator() {
        this.authnRequestTimeLookupStrategy = prc -> Instant.now().minus(this.clockSkew);
        this.requested = PredicateSupport.alwaysTrue();
    }

    public void setClockSkew(@Nonnull Duration skew) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.clockSkew = (Duration)Constraint.isNotNull((Object)skew, (String)"Clock skew cannot be null");
    }

    public void setAuthnRequestTimeLookupStrategy(@Nonnull Function<ProfileRequestContext, Instant> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.ifDestroyedThrowDestroyedComponentException();
        this.authnRequestTimeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"authnRequestTimeLookupStrategy can not be null");
    }

    @Deprecated(forRemoval=true, since="2.2.0")
    public void setRequested(@Nonnull Predicate<ProfileRequestContext> isRequested) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.requested = isRequested;
    }

    public void setAuthnLifetime(@Nonnull Duration lifetime) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        Constraint.isNotNull((Object)lifetime, (String)"Token authentication lifetime cannot be null");
        Constraint.isFalse((boolean)lifetime.isNegative(), (String)"Token authentication lifetime cannot be negative");
        this.authnLifetimeLookupStrategy = FunctionSupport.constant((Object)lifetime);
    }

    public void setAuthnLifetimeLookupStrategy(@Nonnull Function<ProfileRequestContext, Duration> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.ifDestroyedThrowDestroyedComponentException();
        this.authnLifetimeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AuthnLifetime Lookup Strategy can not be null");
    }

    public void doValidate(@Nonnull JWTClaimsSet claimsSet, @Nonnull ProfileRequestContext context) throws JWTValidationException {
        if (!this.requested.test(context)) {
            return;
        }
        try {
            Duration authnLifetime = this.authnLifetimeLookupStrategy.apply(context);
            Date authTimeDate = claimsSet.getDateClaim(IDTokenClaims.AUTHENTICATION_TIME.getClaimName());
            if (authTimeDate == null) {
                throw new JWTValidationException("No authentication time found in token");
            }
            if (authnLifetime == null) {
                throw new JWTValidationException("No authentication lifetime set");
            }
            if (authnLifetime.equals(Duration.ofSeconds(0L))) {
                Instant authnRequestTime = this.authnRequestTimeLookupStrategy.apply(context);
                if (authnRequestTime == null) {
                    this.log.warn("Maximum authentication age of 0 seconds requested, but no authentication request time could be found, can not check for a fresh authentication");
                    throw new JWTValidationException("Maximum authentication age of 0 seconds requested, but no authentication request time could be found, can not check for a fresh authentication");
                }
                if (authTimeDate.toInstant().isBefore(authnRequestTime)) {
                    this.log.warn("JWT token authentication time is not valid. Authentication is not fresh but max_age=0 was requested, re-authentication did not occur");
                    throw new JWTValidationException("JWT token authentication time is not valid. Authentication is not fresh but max_age=0 was requested, re-authentication did not occur");
                }
            } else {
                Instant authTime = authTimeDate.toInstant();
                Instant now = Instant.now();
                Instant latestValid = now.plus(this.clockSkew);
                Instant expiration = authTime.plus(this.clockSkew).plus(authnLifetime);
                if (authTime.isAfter(latestValid)) {
                    this.log.warn("Authentication is not yet valid: auth_time was {}, latest valid is: {}", (Object)authTime, (Object)latestValid);
                    throw new JWTValidationException("JWT token authentication time is not yet valid");
                }
                if (expiration.isBefore(now)) {
                    this.log.warn("Authentication has expired: auth_time was '{}', expired at: '{}', current time: '{}'", new Object[]{authTime, expiration, now});
                    throw new JWTValidationException("JWT token authentication time has expired");
                }
            }
        }
        catch (ParseException e) {
            throw new JWTValidationException("Autentication forced, but no authentication time found in token", (Exception)e);
        }
    }
}

