/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.jwt.claims.impl;

import com.nimbusds.jwt.JWTClaimsSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.jwt.claims.AbstractClaimsValidator;
import net.shibboleth.oidc.jwt.claims.JWTValidationException;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;

@ThreadSafeAfterInit
public class AudienceClaimsValidator
extends AbstractClaimsValidator {
    @NonnullAfterInit
    private BiFunction<ProfileRequestContext, JWTClaimsSet, String> audienceLookupStrategy;
    @Nonnull
    private BiFunction<ProfileRequestContext, JWTClaimsSet, Set<String>> additionalAudiencesLookupStrategy = (prc, claims) -> CollectionSupport.emptySet();
    private boolean allowMissing;
    private boolean extraAudienceValidation = false;
    @Nullable
    private Predicate<ProfileRequestContext> extraAudienceValidationCondition;

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.audienceLookupStrategy == null) {
            throw new ComponentInitializationException("Audience lookup strategy can not be null");
        }
    }

    public void setAudienceLookupStrategy(@Nonnull BiFunction<ProfileRequestContext, JWTClaimsSet, String> strategy) {
        this.checkSetterPreconditions();
        this.audienceLookupStrategy = (BiFunction)Constraint.isNotNull(strategy, (String)"Audience lookup strategy can not be null");
    }

    public void setAdditionalAudiencesLookupStrategy(@Nonnull BiFunction<ProfileRequestContext, JWTClaimsSet, Set<String>> strategy) {
        this.checkSetterPreconditions();
        this.additionalAudiencesLookupStrategy = (BiFunction)Constraint.isNotNull(strategy, (String)"Additional audiences lookup strategy can not be null");
    }

    public void setAllowMissing(boolean flag) {
        this.allowMissing = flag;
    }

    public void setExtraAudienceValidation(boolean flag) {
        this.checkSetterPreconditions();
        this.extraAudienceValidation = flag;
    }

    public void setExtraAudienceValidationCondition(@Nullable Predicate<ProfileRequestContext> condition) {
        this.checkSetterPreconditions();
        this.extraAudienceValidationCondition = condition;
    }

    @Nonnull
    @NotEmpty
    protected Set<String> resolveAcceptedAudiences(@Nonnull JWTClaimsSet claims, @Nonnull ProfileRequestContext context) throws JWTValidationException {
        String acceptedAudience = this.audienceLookupStrategy.apply(context, claims);
        if (acceptedAudience == null) {
            throw new JWTValidationException("Audience value not returned by lookup function");
        }
        return CollectionSupport.setOf((Object)acceptedAudience);
    }

    protected void doValidate(@Nonnull JWTClaimsSet claims, @Nonnull ProfileRequestContext context) throws JWTValidationException {
        List audList;
        Set<String> acceptedAudiences = this.resolveAcceptedAudiences(claims, context);
        Set additionalAudiences = this.additionalAudiencesLookupStrategy.apply(context, claims);
        if (additionalAudiences == null) {
            additionalAudiences = CollectionSupport.emptySet();
        }
        if ((audList = claims.getAudience()) == null || audList.isEmpty()) {
            if (!this.allowMissing) {
                throw new JWTValidationException("JWT missing required audience");
            }
            return;
        }
        List<String> audListFiltered = audList.stream().filter(Objects::nonNull).toList();
        boolean acceptedAudienceMatch = audListFiltered.stream().anyMatch(acceptedAudiences::contains);
        if (!acceptedAudienceMatch) {
            throw new JWTValidationException("JWT audience rejected, no accepted audiences found in: " + String.valueOf(audListFiltered));
        }
        if (audListFiltered.size() > 1 && (this.extraAudienceValidation || this.extraAudienceValidationCondition != null && this.extraAudienceValidationCondition.test(context))) {
            List<String> audListFilteredWithoutAcceptedAud = audListFiltered.stream().filter(aud -> !acceptedAudiences.contains(aud)).toList();
            boolean additionalAudiencesTrusted = audListFilteredWithoutAcceptedAud.stream().allMatch(additionalAudiences::contains);
            if (!additionalAudiencesTrusted) {
                throw new JWTValidationException("JWT audience rejected, additional audiences not trusted: " + String.valueOf(audListFilteredWithoutAcceptedAud));
            }
        }
    }
}

