/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.jwt.claims.impl;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.openid.connect.sdk.claims.AccessTokenHash;
import com.nimbusds.openid.connect.sdk.validators.AccessTokenValidator;
import com.nimbusds.openid.connect.sdk.validators.InvalidHashException;
import java.text.ParseException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.oidc.jwt.claims.AbstractClaimsValidator;
import net.shibboleth.oidc.jwt.claims.JWTValidationException;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class AccessTokenHashValidator
extends AbstractClaimsValidator {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AccessTokenHashValidator.class);
    @NonnullAfterInit
    private Function<ProfileRequestContext, AccessToken> accessTokenLookupStrategy;
    @NonnullAfterInit
    private Function<ProfileRequestContext, JWSHeader> joseHeaderLookupStrategy;
    private boolean allowMissing;

    public void setAllowMissing(boolean flag) {
        this.allowMissing = flag;
    }

    public void setAccessTokenLookupStrategy(@Nonnull Function<ProfileRequestContext, AccessToken> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.ifDestroyedThrowDestroyedComponentException();
        this.accessTokenLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Access Token Lookup Strategy can not be null");
    }

    public void setJoseHeaderLookupStrategy(@Nonnull Function<ProfileRequestContext, JWSHeader> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.ifDestroyedThrowDestroyedComponentException();
        this.joseHeaderLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Jose Header Lookup Strategy can not be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.accessTokenLookupStrategy == null) {
            throw new ComponentInitializationException("Token lookup strategy can not be null");
        }
        if (this.joseHeaderLookupStrategy == null) {
            throw new ComponentInitializationException("JOSE Header lookup strategy can not be null");
        }
    }

    protected void doValidate(@Nonnull JWTClaimsSet claims, @Nonnull ProfileRequestContext context) throws JWTValidationException {
        try {
            String atHashClaim = claims.getStringClaim("at_hash");
            if (StringSupport.trimOrNull((String)atHashClaim) == null) {
                if (this.allowMissing) {
                    this.log.debug("No at_hash claim present in id_token, no checks performed");
                    return;
                }
                throw new JWTValidationException("Required at_hash claim not present in id_token");
            }
            AccessToken accessToken = this.accessTokenLookupStrategy.apply(context);
            if (accessToken == null) {
                throw new JWTValidationException("Access Tokene was not found, cannot validate 'at_hash' claim");
            }
            JWSHeader joseHeader = this.joseHeaderLookupStrategy.apply(context);
            if (joseHeader == null) {
                throw new JWTValidationException("JWS Header from id_token not found, cannot validate 'at_hash' claim");
            }
            AccessTokenValidator.validate((AccessToken)accessToken, (JWSAlgorithm)joseHeader.getAlgorithm(), (AccessTokenHash)new AccessTokenHash(atHashClaim));
        }
        catch (InvalidHashException | ParseException e) {
            throw new JWTValidationException((Exception)e);
        }
    }
}

