/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.jose.impl;

import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.security.jose.criterion.ProviderMetadataCriterion;
import net.shibboleth.oidc.security.jose.impl.DefaultDataEncryptionAlgorithmsLookupStrategy;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import org.opensaml.xmlsec.algorithm.AlgorithmRegistry;
import org.slf4j.Logger;

public class ProviderMetadataDataEncryptionAlgorithmsLookupStrategy
extends DefaultDataEncryptionAlgorithmsLookupStrategy {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ProviderMetadataDataEncryptionAlgorithmsLookupStrategy.class);
    @Nonnull
    private final Function<OIDCProviderMetadata, List<String>> providerEncryptionMethodsLookupStrategy;

    public ProviderMetadataDataEncryptionAlgorithmsLookupStrategy(@Nonnull @ParameterName(name="providerEncryptionMethodsLookupStrategy") Function<OIDCProviderMetadata, List<String>> strategy, @Nullable @ParameterName(name="AlgorithmRegistry") AlgorithmRegistry registry) {
        super(registry);
        this.providerEncryptionMethodsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"The provider key transport lookup strategy can not be null");
    }

    public ProviderMetadataDataEncryptionAlgorithmsLookupStrategy(@Nonnull @ParameterName(name="providerKeyTransportAlgorithmsLookupStrategy") Function<OIDCProviderMetadata, List<String>> strategy) {
        super(null);
        this.providerEncryptionMethodsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"The provider key transport lookup strategy can not be null");
    }

    @Override
    @Nullable
    public List<String> apply(@Nullable CriteriaSet criteria, @Nullable Predicate<String> includeExcludePredicate) {
        OIDCProviderMetadata metadata;
        ProviderMetadataCriterion metaCrit = criteria != null ? (ProviderMetadataCriterion)criteria.get(ProviderMetadataCriterion.class) : null;
        OIDCProviderMetadata oIDCProviderMetadata = metadata = metaCrit != null ? metaCrit.getMetadata() : null;
        if (metadata == null) {
            this.log.debug("No provider metadata, falling back to default local behaviour");
            return super.apply(criteria, includeExcludePredicate);
        }
        List<String> dataEncryptionMethods = this.providerEncryptionMethodsLookupStrategy.apply(metadata);
        this.log.trace("Resolved effective data encryption algorithms from provider metadata: {}", dataEncryptionMethods);
        if (dataEncryptionMethods == null) {
            this.log.debug("Provider metadata does not contain supported 'enc' algorithms, falling back to default local behaviour");
            return super.apply(criteria, includeExcludePredicate);
        }
        List<String> dataEncryptionAlgorithmsSupported = this.getDataEncryptionAlgorithmsFromConfiguration(criteria, includeExcludePredicate);
        this.log.trace("Resolved supported data encryption algorithms from config: {}", dataEncryptionAlgorithmsSupported);
        List<String> supportedAndConfiguredDataEncryptionAlgorithms = this.findAlgorithmIntersection(dataEncryptionMethods, dataEncryptionAlgorithmsSupported);
        this.log.debug("Supported and configured data encryption algorithms: {}", supportedAndConfiguredDataEncryptionAlgorithms);
        if (supportedAndConfiguredDataEncryptionAlgorithms.isEmpty()) {
            this.log.warn("No supported data encryption method. Provider metadata and configuration are not compatible");
            return Collections.emptyList();
        }
        return supportedAndConfiguredDataEncryptionAlgorithms;
    }
}

