/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.jose.impl;

import com.google.common.base.Strings;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import java.security.Key;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.security.CredentialConversionUtil;
import net.shibboleth.oidc.security.credential.JWKCredential;
import net.shibboleth.oidc.security.credential.impl.DataEncryptionAlgorithmCriterion;
import net.shibboleth.oidc.security.credential.impl.KeyManagmentAlgorithmCriterion;
import net.shibboleth.oidc.security.jose.EncryptionConfiguration;
import net.shibboleth.oidc.security.jose.EncryptionParameters;
import net.shibboleth.oidc.security.jose.EncryptionParametersResolver;
import net.shibboleth.oidc.security.jose.criterion.EncryptionConfigurationCriterion;
import net.shibboleth.oidc.security.jose.impl.DefaultDataEncryptionAlgorithmsLookupStrategy;
import net.shibboleth.oidc.security.jose.impl.DefaultKeyTransportEncryptionAlgorithmsLookupStrategy;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.NonnullSupplier;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.credential.criteria.impl.EvaluableKeyAlgorithmCredentialCriterion;
import org.opensaml.security.criteria.KeyAlgorithmCriterion;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.xmlsec.algorithm.AlgorithmDescriptor;
import org.opensaml.xmlsec.algorithm.AlgorithmRegistry;
import org.opensaml.xmlsec.algorithm.AlgorithmSupport;
import org.opensaml.xmlsec.criterion.EncryptionOptionalCriterion;
import org.opensaml.xmlsec.impl.AbstractSecurityParametersResolver;
import org.opensaml.xmlsec.impl.AlgorithmRuntimeSupportedPredicate;
import org.slf4j.Logger;

public class DefaultEncryptionParametersResolver
extends AbstractSecurityParametersResolver<EncryptionParameters>
implements EncryptionParametersResolver {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DefaultEncryptionParametersResolver.class);
    @Nullable
    private AlgorithmRegistry algorithmRegistry = AlgorithmSupport.getGlobalAlgorithmRegistry();
    @Nonnull
    private BiFunction<CriteriaSet, Predicate<String>, List<String>> dataEncryptionAlgorithmsLookupStrategy;
    @Nonnull
    private BiFunction<CriteriaSet, Predicate<String>, List<String>> keyTransportEncryptionAlgorithmsLookupStrategy = new DefaultKeyTransportEncryptionAlgorithmsLookupStrategy(null);

    public DefaultEncryptionParametersResolver() {
        this.dataEncryptionAlgorithmsLookupStrategy = new DefaultDataEncryptionAlgorithmsLookupStrategy(null);
    }

    public void setDataEncryptionAlgorithmsLookupStrategy(BiFunction<CriteriaSet, Predicate<String>, List<String>> strategy) {
        this.dataEncryptionAlgorithmsLookupStrategy = (BiFunction)Constraint.isNotNull(strategy, (String)"dataEncryptionAlgorithmsLookupStrategy can not be null");
    }

    public void setKeyTransportEncryptionAlgorithmsLookupStrategy(BiFunction<CriteriaSet, Predicate<String>, List<String>> strategy) {
        this.keyTransportEncryptionAlgorithmsLookupStrategy = (BiFunction)Constraint.isNotNull(strategy, (String)"keyTransportEncryptionAlgorithmsLookupStrategy can not be null");
    }

    @Nonnull
    public AlgorithmRegistry getAlgorithmRegistry() {
        if (this.algorithmRegistry == null) {
            return AlgorithmSupport.ensureGlobalAlgorithmRegistry();
        }
        assert (this.algorithmRegistry != null);
        return this.algorithmRegistry;
    }

    public void setAlgorithmRegistry(@Nonnull AlgorithmRegistry registry) {
        this.algorithmRegistry = (AlgorithmRegistry)Constraint.isNotNull((Object)registry, (String)"AlgorithmRegistry was null");
    }

    @Nonnull
    public Iterable<EncryptionParameters> resolve(@Nullable CriteriaSet criteria) throws ResolverException {
        EncryptionParameters params = this.resolveSingle(criteria);
        if (params != null) {
            return CollectionSupport.singletonList((Object)params);
        }
        return CollectionSupport.emptyList();
    }

    @Nullable
    public EncryptionParameters resolveSingle(@Nullable CriteriaSet criteria) throws ResolverException {
        EncryptionConfigurationCriterion encCrit;
        EncryptionConfigurationCriterion encryptionConfigurationCriterion = encCrit = criteria != null ? (EncryptionConfigurationCriterion)criteria.get(EncryptionConfigurationCriterion.class) : null;
        if (encCrit == null) {
            throw new ResolverException("Resolver requires an instance of JWTEncryptionConfigurationCriterion");
        }
        assert (criteria != null);
        Predicate<String> includeExcludePredicate = this.getIncludeExcludePredicate(criteria);
        EncryptionParameters params = new EncryptionParameters();
        this.resolveAndPopulateCredentialsAndAlgorithms(params, criteria, includeExcludePredicate);
        boolean encryptionOptional = false;
        EncryptionOptionalCriterion encryptionOptionalCrit = (EncryptionOptionalCriterion)criteria.get(EncryptionOptionalCriterion.class);
        if (encryptionOptionalCrit != null) {
            encryptionOptional = encryptionOptionalCrit.isEncryptionOptional();
        }
        if (this.validate(params, encryptionOptional)) {
            this.logResult(params);
            return params;
        }
        return null;
    }

    @Nullable
    protected CredentialResolver resolveKEKCredentialResolver(@Nonnull CriteriaSet criteria) {
        EncryptionConfigurationCriterion encCrit = (EncryptionConfigurationCriterion)criteria.get(EncryptionConfigurationCriterion.class);
        assert (encCrit != null);
        for (EncryptionConfiguration config : encCrit.getConfigurations()) {
            if (config.getKEKCredentialResolver() == null) continue;
            return config.getKEKCredentialResolver();
        }
        return null;
    }

    @Nullable
    protected CredentialResolver resolveContentEncryptionKeyCredentialResolver(@Nonnull CriteriaSet criteria) {
        EncryptionConfigurationCriterion encCrit = (EncryptionConfigurationCriterion)criteria.get(EncryptionConfigurationCriterion.class);
        assert (encCrit != null);
        for (EncryptionConfiguration config : encCrit.getConfigurations()) {
            if (config.getContentEncryptionKeyCredentialResolver() == null) continue;
            return config.getContentEncryptionKeyCredentialResolver();
        }
        return null;
    }

    protected void logResult(@Nonnull EncryptionParameters params) {
        if (this.log.isDebugEnabled()) {
            Key dataKey;
            Key keyTransportKey;
            this.log.debug("Resolved EncryptionParameters:");
            Credential keyTransportCredential = params.getKeyTransportEncryptionCredential();
            Key key = keyTransportKey = keyTransportCredential == null ? null : CredentialSupport.extractEncryptionKey((Credential)keyTransportCredential);
            if (keyTransportKey != null) {
                this.log.debug("\tKey transport credential with key algorithm: {}", (Object)keyTransportKey.getAlgorithm());
            } else {
                this.log.debug("\tKey transport credential: null");
            }
            this.log.debug("\tKey transport algorithm URI: {}", (Object)params.getKeyTransportEncryptionAlgorithm());
            Credential dataCredential = params.getDataEncryptionCredential();
            Key key2 = dataKey = dataCredential == null ? null : CredentialSupport.extractEncryptionKey((Credential)dataCredential);
            if (dataKey != null) {
                this.log.debug("\tData encryption credential with key algorithm: {}", (Object)dataKey.getAlgorithm());
            } else {
                this.log.debug("\tData encryption credential: null");
            }
            this.log.debug("\tData encryption algorithm URI: {}", (Object)params.getDataEncryptionAlgorithm());
        }
    }

    protected boolean validate(@Nonnull EncryptionParameters params, boolean encryptionOptional) {
        if (params.getKeyTransportEncryptionCredential() == null && params.getDataEncryptionCredential() == null) {
            String msg = "Validation failure: Failed to resolve an encryption key";
            if (encryptionOptional) {
                this.log.debug("Validation failure: Failed to resolve an encryption key");
            } else {
                this.log.warn("Validation failure: Failed to resolve an encryption key");
            }
            return false;
        }
        if (params.getKeyTransportEncryptionCredential() != null && params.getKeyTransportEncryptionAlgorithm() == null) {
            String msg = "Validation failure: Unable to resolve key encryption algorithm URI for credential";
            if (encryptionOptional) {
                this.log.debug("Validation failure: Unable to resolve key encryption algorithm URI for credential");
            } else {
                this.log.warn("Validation failure: Unable to resolve key encryption algorithm URI for credential");
            }
            return false;
        }
        if (params.getDataEncryptionCredential() != null && params.getDataEncryptionAlgorithm() == null) {
            String msg = "Validation failure: Unable to resolve data encryption algorithm URI for credential";
            if (encryptionOptional) {
                this.log.debug("Validation failure: Unable to resolve data encryption algorithm URI for credential");
            } else {
                this.log.warn("Validation failure: Unable to resolve data encryption algorithm URI for credential");
            }
            return false;
        }
        if (params.getKeyTransportEncryptionCredential() != null && params.getDataEncryptionCredential() == null && params.getDataEncryptionAlgorithm() == null) {
            String msg = "Validation failure: Unable to resolve a data encryption algorithm URI for auto-generation of data encryption key";
            if (encryptionOptional) {
                this.log.debug("Validation failure: Unable to resolve a data encryption algorithm URI for auto-generation of data encryption key");
            } else {
                this.log.warn("Validation failure: Unable to resolve a data encryption algorithm URI for auto-generation of data encryption key");
            }
            return false;
        }
        return true;
    }

    @Nonnull
    protected Predicate<String> getIncludeExcludePredicate(@Nonnull CriteriaSet criteria) {
        EncryptionConfigurationCriterion encCrit = (EncryptionConfigurationCriterion)criteria.get(EncryptionConfigurationCriterion.class);
        assert (encCrit != null);
        return this.resolveIncludeExcludePredicate(criteria, encCrit.getConfigurations());
    }

    protected void resolveAndPopulateCredentialsAndAlgorithms(@Nonnull EncryptionParameters params, @Nonnull CriteriaSet criteria, @Nonnull Predicate<String> includeExcludePredicate) {
        EncryptionConfigurationCriterion encCrit = (EncryptionConfigurationCriterion)criteria.get(EncryptionConfigurationCriterion.class);
        if (encCrit == null) {
            this.log.debug("No encryption configuration criterion, encryption parameters can not be resolved");
            return;
        }
        if (!criteria.contains(UsageCriterion.class)) {
            criteria.add((Object)new UsageCriterion(UsageType.ENCRYPTION));
        }
        List keyTransportAlgorithms = this.keyTransportEncryptionAlgorithmsLookupStrategy.apply(criteria, includeExcludePredicate);
        this.log.trace("Resolved effective key transport algorithms: {}", keyTransportAlgorithms);
        List dataEncryptionAlgorithms = this.dataEncryptionAlgorithmsLookupStrategy.apply(criteria, includeExcludePredicate);
        this.log.trace("Resolved effective data encryption algorithms: {}", dataEncryptionAlgorithms);
        this.resolveCredentialForSupportedAlgorithm(criteria, this.convertStringAlgorithmURIsToJwkAlgorithms(keyTransportAlgorithms != null ? keyTransportAlgorithms : CollectionSupport.emptyList()), this.convertStringEncryptionMethodURIsToEncryptionMethods(dataEncryptionAlgorithms != null ? dataEncryptionAlgorithms : CollectionSupport.emptyList()), params);
    }

    protected void resolveCredentialForSupportedAlgorithm(@Nonnull CriteriaSet criteria, @Nonnull List<JWEAlgorithm> keyTransportAlgorithms, @Nonnull List<EncryptionMethod> dataEncryptionAlgorithms, @Nonnull EncryptionParameters params) {
        for (JWEAlgorithm algorithm : keyTransportAlgorithms) {
            assert (algorithm != null);
            if (JWEAlgorithm.DIR.equals((Object)algorithm)) {
                if (!this.buildDirectEncryptionParameters(params, criteria, dataEncryptionAlgorithms, algorithm)) continue;
                return;
            }
            if (JWEAlgorithm.Family.AES_GCM_KW.contains((Object)algorithm) || JWEAlgorithm.Family.AES_KW.contains((Object)algorithm)) {
                if (!this.buildKeyWrappingParameters(params, criteria, dataEncryptionAlgorithms, algorithm)) continue;
                return;
            }
            if (JWEAlgorithm.Family.ASYMMETRIC.contains((Object)algorithm)) {
                if (!this.buildKeyEncryptionOrAgreementParameters(params, criteria, dataEncryptionAlgorithms, algorithm)) continue;
                return;
            }
            this.log.trace("Algorithm '{}' is not supported, moving on", (Object)algorithm);
        }
    }

    private boolean buildDirectEncryptionParameters(@Nonnull EncryptionParameters params, @Nonnull CriteriaSet criteria, @Nonnull List<EncryptionMethod> dataEncryptionAlgorithms, @Nonnull JWEAlgorithm algorithm) {
        this.log.debug("Looking for encryption parameters for algorithm '{}'", (Object)algorithm);
        for (EncryptionMethod method : dataEncryptionAlgorithms) {
            assert (method != null);
            CriteriaSet credentialCriteria = this.buildEncryptionKeyAlgorithmCriteria(criteria, algorithm, method);
            List<Credential> dataEncryptionCredentials = this.getEffectiveDataEncryptionCredentials(credentialCriteria);
            this.log.debug("Resolved {} possible direct encryption credential(s) for 'alg={}' and 'enc={}'", new Object[]{dataEncryptionCredentials.size(), algorithm.getName(), method.getName()});
            for (Credential credential : dataEncryptionCredentials) {
                assert (credential != null);
                if (!this.checkCredentialSupportsAlgorithm(credential, algorithm) || !this.checkCredentialSupportsEncryptionMethod(credential, method)) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Resolved compatible key '{}' for 'alg={}' and 'enc={}'", new Object[]{CredentialConversionUtil.resolveKid((Credential)credential), algorithm.getName(), method.getName()});
                }
                params.setKeyTransportEncryptionAlgorithm(JWEAlgorithm.DIR.getName());
                params.setDataEncryptionCredential(credential);
                params.setDataEncryptionAlgorithm(method.getName());
                return true;
            }
        }
        this.log.debug("No resolved credentials are compatible with algorithm '{}'", (Object)algorithm);
        return false;
    }

    private boolean buildKeyWrappingParameters(@Nonnull EncryptionParameters params, @Nonnull CriteriaSet criteria, @Nonnull List<EncryptionMethod> dataEncryptionAlgorithms, @Nonnull JWEAlgorithm algorithm) {
        this.log.debug("Looking for encryption parameters for algorithm '{}'", (Object)algorithm);
        for (EncryptionMethod method : dataEncryptionAlgorithms) {
            assert (method != null);
            CriteriaSet credentialCriteria = this.buildKeyManagmentAlgorithmCriteria(criteria, algorithm, method);
            List<Credential> keyTransportCredentials = this.getEffectiveKeyTransportCredentials(credentialCriteria);
            this.log.debug("Resolved {} possible key transport credentials for 'alg={}' and 'enc={}'", new Object[]{keyTransportCredentials.size(), algorithm.getName(), method.getName()});
            for (Credential credential : keyTransportCredentials) {
                assert (credential != null);
                if (!this.checkCredentialSupportsAlgorithm(credential, algorithm)) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Resolved compatible key '{}' for 'alg={}' and 'enc={}'", new Object[]{CredentialConversionUtil.resolveKid((Credential)credential), algorithm.getName(), method.getName()});
                }
                params.setKeyTransportEncryptionCredential(credential);
                params.setKeyTransportEncryptionAlgorithm(algorithm.getName());
                params.setDataEncryptionAlgorithm(method.getName());
                return true;
            }
        }
        this.log.debug("No resolved credentials are compatible with algorithm '{}'", (Object)algorithm);
        return false;
    }

    private boolean buildKeyEncryptionOrAgreementParameters(@Nonnull EncryptionParameters params, @Nonnull CriteriaSet criteria, @Nonnull List<EncryptionMethod> dataEncryptionAlgorithms, @Nonnull JWEAlgorithm algorithm) {
        this.log.debug("Looking for encryption parameters for algorithm '{}'", (Object)algorithm);
        EncryptionMethod encryptionMethod = this.resolveEncryptionMethod(dataEncryptionAlgorithms);
        if (encryptionMethod == null) {
            this.log.debug("Could not resolve encryption method");
            return false;
        }
        List<Credential> keyTransportCredentials = this.getEffectiveKeyTransportCredentials(this.buildKeyManagmentAlgorithmCriteria(criteria, algorithm, encryptionMethod));
        this.log.debug("Resolved {} possible key transport credentials for 'alg={}'", (Object)keyTransportCredentials.size(), (Object)algorithm.getName());
        for (Credential credential : keyTransportCredentials) {
            assert (credential != null);
            if (!this.checkCredentialSupportsAlgorithm(credential, algorithm)) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Resolved compatible key '{}' for 'alg={}' and 'enc={}'", new Object[]{CredentialConversionUtil.resolveKid((Credential)credential), algorithm.getName(), encryptionMethod.getName()});
            }
            params.setKeyTransportEncryptionCredential(credential);
            params.setKeyTransportEncryptionAlgorithm(algorithm.getName());
            params.setDataEncryptionAlgorithm(encryptionMethod.getName());
            return true;
        }
        this.log.debug("No resolved credentials are compatible with algorithm '{}'", (Object)algorithm);
        return false;
    }

    @Nonnull
    private CriteriaSet buildKeyManagmentAlgorithmCriteria(@Nonnull CriteriaSet existingCriteria, @Nonnull JWEAlgorithm alg, @Nonnull EncryptionMethod enc) {
        CriteriaSet credentialCriteria = new CriteriaSet();
        credentialCriteria.addAll((Collection)existingCriteria);
        String algName = alg.getName();
        assert (algName != null);
        credentialCriteria.add((Object)new KeyManagmentAlgorithmCriterion(algName));
        String encName = enc.getName();
        assert (encName != null);
        credentialCriteria.add((Object)new DataEncryptionAlgorithmCriterion(encName));
        String jcaKeyAlgorithm = AlgorithmSupport.getKeyAlgorithm((String)algName);
        if (!Strings.isNullOrEmpty((String)jcaKeyAlgorithm)) {
            assert (jcaKeyAlgorithm != null);
            credentialCriteria.add((Object)new EvaluableKeyAlgorithmCredentialCriterion(new KeyAlgorithmCriterion(jcaKeyAlgorithm)));
        }
        return credentialCriteria;
    }

    @Nonnull
    private CriteriaSet buildEncryptionKeyAlgorithmCriteria(@Nonnull CriteriaSet existingCriteria, @Nonnull JWEAlgorithm alg, @Nonnull EncryptionMethod enc) {
        CriteriaSet credentialCriteria = new CriteriaSet();
        credentialCriteria.addAll((Collection)existingCriteria);
        String algName = alg.getName();
        assert (algName != null);
        credentialCriteria.add((Object)new KeyManagmentAlgorithmCriterion(algName));
        String encName = enc.getName();
        assert (encName != null);
        credentialCriteria.add((Object)new DataEncryptionAlgorithmCriterion(encName));
        String jcaEncAlgorithm = AlgorithmSupport.getKeyAlgorithm((String)encName);
        if (!Strings.isNullOrEmpty((String)jcaEncAlgorithm)) {
            assert (jcaEncAlgorithm != null);
            credentialCriteria.add((Object)new EvaluableKeyAlgorithmCredentialCriterion(new KeyAlgorithmCriterion(jcaEncAlgorithm)));
        }
        return credentialCriteria;
    }

    protected boolean checkCredentialSupportsAlgorithm(@Nonnull Credential credential, @Nonnull JWEAlgorithm algorithm) {
        String algName = algorithm.getName();
        assert (algName != null);
        if (!(credential instanceof JWKCredential)) {
            return false;
        }
        if (credential.getUsageType() != UsageType.ENCRYPTION && credential.getUsageType() != UsageType.UNSPECIFIED) {
            return false;
        }
        if (!this.checkKeyWithAlgorithm((JWKCredential)credential, algorithm)) {
            return false;
        }
        return this.checkKeyAlgorithmAndLength(credential, algName);
    }

    protected boolean checkCredentialSupportsEncryptionMethod(@Nonnull Credential credential, @Nonnull EncryptionMethod encMethod) {
        Key key = CredentialSupport.extractEncryptionKey((Credential)credential);
        if (key == null) {
            return false;
        }
        AlgorithmDescriptor descriptor = this.getAlgorithmRegistry().get(encMethod.getName());
        if (descriptor == null) {
            return false;
        }
        return AlgorithmSupport.checkKeyAlgorithmAndLength((Key)key, (AlgorithmDescriptor)descriptor);
    }

    private boolean checkKeyWithAlgorithm(@Nonnull JWKCredential credential, @Nonnull JWEAlgorithm algorithm) {
        if (credential.getAlgorithm() != null) {
            return algorithm.equals((Object)credential.getAlgorithm());
        }
        Key key = CredentialSupport.extractEncryptionKey((Credential)credential);
        if (key == null) {
            this.log.debug("Extracted encryption key was null");
            return false;
        }
        if (JWEAlgorithm.Family.RSA.contains((Object)algorithm) && key.getAlgorithm().equals("RSA")) {
            return true;
        }
        if (JWEAlgorithm.Family.ECDH_ES.contains((Object)algorithm) && key.getAlgorithm().equals("EC")) {
            return true;
        }
        return JWEAlgorithm.Family.SYMMETRIC.contains((Object)algorithm) && key.getAlgorithm().equals("AES");
    }

    @Nonnull
    protected List<Credential> getEffectiveDataEncryptionCredentials(@Nonnull CriteriaSet criteria) {
        CredentialResolver resolver = this.resolveContentEncryptionKeyCredentialResolver(criteria);
        if (resolver == null) {
            return CollectionSupport.emptyList();
        }
        try {
            ArrayList<Credential> credentialsAsList = new ArrayList<Credential>();
            Iterable credentials = resolver.resolve((Object)criteria);
            credentials.forEach(credentialsAsList::add);
            return credentialsAsList;
        }
        catch (ResolverException e) {
            this.log.warn("Unable to resolve data encryption credentials", (Throwable)e);
            return CollectionSupport.emptyList();
        }
    }

    @Nonnull
    protected List<Credential> getEffectiveKeyTransportCredentials(@Nonnull CriteriaSet criteria) {
        CredentialResolver resolver = this.resolveKEKCredentialResolver(criteria);
        if (resolver == null) {
            return CollectionSupport.emptyList();
        }
        try {
            ArrayList<Credential> credentialsAsList = new ArrayList<Credential>();
            Iterable credentials = resolver.resolve((Object)criteria);
            credentials.forEach(credentialsAsList::add);
            return credentialsAsList;
        }
        catch (ResolverException e) {
            this.log.warn("Unable to resolve data encryption credentials", (Throwable)e);
            return CollectionSupport.emptyList();
        }
    }

    @Nullable
    protected EncryptionMethod resolveEncryptionMethod(@Nonnull List<EncryptionMethod> dataEncryptionAlgorithms) {
        if (!dataEncryptionAlgorithms.isEmpty()) {
            return dataEncryptionAlgorithms.get(0);
        }
        return null;
    }

    @Nonnull
    protected List<JWEAlgorithm> convertStringAlgorithmURIsToJwkAlgorithms(@Nonnull List<String> algos) {
        return (List)((NonnullSupplier)algos.stream().filter(Objects::nonNull).map(JWEAlgorithm::parse).collect(CollectionSupport.nonnullCollector(Collectors.toList()))).get();
    }

    @Nonnull
    protected List<EncryptionMethod> convertStringEncryptionMethodURIsToEncryptionMethods(@Nonnull List<String> encMethods) {
        return (List)((NonnullSupplier)encMethods.stream().filter(Objects::nonNull).map(EncryptionMethod::parse).collect(CollectionSupport.nonnullCollector(Collectors.toList()))).get();
    }

    @Nonnull
    protected Predicate<String> getAlgorithmRuntimeSupportedPredicate() {
        return new AlgorithmRuntimeSupportedPredicate(this.getAlgorithmRegistry());
    }

    protected boolean credentialSupportsAlgorithm(@Nonnull Credential credential, @Nonnull @NotEmpty String algorithm) {
        return AlgorithmSupport.credentialSupportsAlgorithmForEncryption((Credential)credential, (AlgorithmDescriptor)this.getAlgorithmRegistry().get(algorithm));
    }

    protected boolean checkKeyAlgorithmAndLength(@Nonnull Credential credential, @Nonnull @NotEmpty String algorithm) {
        Key key = CredentialSupport.extractEncryptionKey((Credential)credential);
        if (key == null) {
            return false;
        }
        AlgorithmDescriptor descriptor = this.getAlgorithmRegistry().get(algorithm);
        if (descriptor == null) {
            return false;
        }
        boolean valid = AlgorithmSupport.checkKeyAlgorithmAndLength((Key)key, (AlgorithmDescriptor)descriptor);
        if (!valid) {
            this.log.trace("Key '{}' does not match algorithm and key length requirement for '{}'", (Object)CredentialConversionUtil.resolveKid((Credential)credential), (Object)algorithm);
        }
        return valid;
    }

    protected boolean isKeyEncryptionAlgorithm(@Nonnull String algorithm) {
        return AlgorithmSupport.isKeyEncryptionAlgorithm((AlgorithmDescriptor)this.getAlgorithmRegistry().get(algorithm));
    }

    protected boolean isDataEncryptionAlgorithm(String algorithm) {
        return AlgorithmSupport.isDataEncryptionAlgorithm((AlgorithmDescriptor)this.getAlgorithmRegistry().get(algorithm));
    }
}

