/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.jose.impl;

import com.nimbusds.jwt.SignedJWT;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.security.jose.SignatureValidationConfiguration;
import net.shibboleth.oidc.security.jose.SignatureValidationParameters;
import net.shibboleth.oidc.security.jose.SignatureValidationParametersResolver;
import net.shibboleth.oidc.security.jose.criterion.SignatureValidationConfigurationCriterion;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.security.trust.TrustEngine;
import org.opensaml.xmlsec.AlgorithmPolicyParameters;
import org.opensaml.xmlsec.impl.AbstractSecurityParametersResolver;
import org.slf4j.Logger;

public class BasicSignatureValidationParametersResolver
extends AbstractSecurityParametersResolver<SignatureValidationParameters>
implements SignatureValidationParametersResolver {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(BasicSignatureValidationParametersResolver.class);

    @Nonnull
    public Iterable<SignatureValidationParameters> resolve(@Nullable CriteriaSet criteria) throws ResolverException {
        SignatureValidationParameters params = this.resolveSingle(criteria);
        if (params != null) {
            return CollectionSupport.singletonList((Object)params);
        }
        return CollectionSupport.emptyList();
    }

    @Nullable
    public SignatureValidationParameters resolveSingle(@Nullable CriteriaSet criteria) throws ResolverException {
        SignatureValidationConfigurationCriterion validationCrit;
        SignatureValidationConfigurationCriterion signatureValidationConfigurationCriterion = validationCrit = criteria != null ? (SignatureValidationConfigurationCriterion)criteria.get(SignatureValidationConfigurationCriterion.class) : null;
        if (validationCrit == null) {
            throw new ResolverException("Resolver requires an instance of SignatureValidationConfigurationCriterion");
        }
        assert (criteria != null);
        SignatureValidationParameters params = new SignatureValidationParameters();
        this.resolveAndPopulateIncludesExcludes((AlgorithmPolicyParameters)params, criteria, validationCrit.getConfigurations());
        params.setSignatureTrustEngine(this.resolveSignatureTrustEngine(criteria));
        this.logResult(params);
        return params;
    }

    protected void logResult(@Nonnull SignatureValidationParameters params) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Resolved JWT SignatureValidationParameters:");
            this.log.debug("\tAlgorithm includes: {}", (Object)params.getIncludedAlgorithms());
            this.log.debug("\tAlgorithm excludes: {}", (Object)params.getExcludedAlgorithms());
            this.log.debug("\tSignatureTrustEngine: {}", (Object)(params.getSignatureTrustEngine() != null ? "present" : "null"));
        }
    }

    @Nullable
    protected TrustEngine<SignedJWT> resolveSignatureTrustEngine(@Nonnull CriteriaSet criteria) {
        SignatureValidationConfigurationCriterion validationCrit = (SignatureValidationConfigurationCriterion)criteria.get(SignatureValidationConfigurationCriterion.class);
        assert (validationCrit != null);
        for (SignatureValidationConfiguration config : validationCrit.getConfigurations()) {
            if (config.getSignatureTrustEngine() == null) continue;
            return config.getSignatureTrustEngine();
        }
        return null;
    }
}

