/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.jose.impl;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import java.security.Key;
import java.security.PrivateKey;
import java.security.interfaces.ECKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.crypto.SecretKey;
import net.shibboleth.oidc.security.CredentialConversionUtil;
import net.shibboleth.oidc.security.credential.JWACredentialSupport;
import net.shibboleth.oidc.security.jose.SignatureSigningConfiguration;
import net.shibboleth.oidc.security.jose.SignatureSigningParameters;
import net.shibboleth.oidc.security.jose.SignatureSigningParametersResolver;
import net.shibboleth.oidc.security.jose.criterion.SignatureSigningConfigurationCriterion;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.xmlsec.algorithm.AlgorithmDescriptor;
import org.opensaml.xmlsec.algorithm.AlgorithmRegistry;
import org.opensaml.xmlsec.algorithm.AlgorithmSupport;
import org.opensaml.xmlsec.impl.AbstractSecurityParametersResolver;
import org.opensaml.xmlsec.impl.AlgorithmRuntimeSupportedPredicate;
import org.slf4j.Logger;

public class BasicSignatureSigningParametersResolver
extends AbstractSecurityParametersResolver<SignatureSigningParameters>
implements SignatureSigningParametersResolver {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(BasicSignatureSigningParametersResolver.class);
    @Nullable
    private AlgorithmRegistry algorithmRegistry = AlgorithmSupport.getGlobalAlgorithmRegistry();

    @Nonnull
    public AlgorithmRegistry getAlgorithmRegistry() {
        if (this.algorithmRegistry == null) {
            return AlgorithmSupport.ensureGlobalAlgorithmRegistry();
        }
        assert (this.algorithmRegistry != null);
        return this.algorithmRegistry;
    }

    public void setAlgorithmRegistry(@Nonnull AlgorithmRegistry registry) {
        this.algorithmRegistry = (AlgorithmRegistry)Constraint.isNotNull((Object)registry, (String)"AlgorithmRegistry was null");
    }

    @Nonnull
    public Iterable<SignatureSigningParameters> resolve(@Nullable CriteriaSet criteria) throws ResolverException {
        SignatureSigningParameters params = this.resolveSingle(criteria);
        if (params != null) {
            return CollectionSupport.singletonList((Object)params);
        }
        return CollectionSupport.emptyList();
    }

    @Nullable
    public SignatureSigningParameters resolveSingle(@Nullable CriteriaSet criteria) throws ResolverException {
        SignatureSigningConfigurationCriterion signingCrit;
        SignatureSigningConfigurationCriterion signatureSigningConfigurationCriterion = signingCrit = criteria != null ? (SignatureSigningConfigurationCriterion)criteria.get(SignatureSigningConfigurationCriterion.class) : null;
        if (signingCrit == null) {
            throw new ResolverException("Resolver requires an instance of SignatureSigningConfigurationCriterion");
        }
        assert (criteria != null);
        Predicate<String> includeExcludePredicate = this.getIncludeExcludePredicate(criteria);
        SignatureSigningParameters params = new SignatureSigningParameters();
        this.resolveAndPopulateCredentialAndSignatureAlgorithm(params, criteria, includeExcludePredicate);
        if (this.validate(params)) {
            this.logResult(params);
            return params;
        }
        return null;
    }

    protected void logResult(@Nonnull SignatureSigningParameters params) {
        if (this.log.isDebugEnabled()) {
            Key signingKey;
            this.log.debug("Resolved SignatureSigningParameters:");
            Credential signingCred = params.getSigningCredential();
            Key key = signingKey = signingCred != null ? CredentialSupport.extractSigningKey((Credential)signingCred) : null;
            if (signingKey != null) {
                this.log.debug("\tSigning credential with key algorithm: {}", (Object)signingKey.getAlgorithm());
            } else {
                this.log.debug("\tSigning credential: null");
            }
            this.log.debug("\tSignature algorithm URI: {}", (Object)params.getSignatureAlgorithm());
        }
    }

    protected boolean validate(@Nonnull SignatureSigningParameters params) {
        if (params.getSigningCredential() == null) {
            this.log.warn("Validation failure: Unable to resolve signing credential");
            return false;
        }
        if (params.getSignatureAlgorithm() == null) {
            this.log.warn("Validation failure: Unable to resolve signing algorithm URI");
            return false;
        }
        return true;
    }

    @Nonnull
    protected Predicate<String> getIncludeExcludePredicate(@Nonnull CriteriaSet criteria) {
        SignatureSigningConfigurationCriterion signingCrit = (SignatureSigningConfigurationCriterion)criteria.get(SignatureSigningConfigurationCriterion.class);
        assert (signingCrit != null);
        return this.resolveIncludeExcludePredicate(criteria, signingCrit.getConfigurations());
    }

    protected void resolveAndPopulateCredentialAndSignatureAlgorithm(@Nonnull SignatureSigningParameters params, @Nonnull CriteriaSet criteria, @Nonnull Predicate<String> includeExcludePredicate) {
        List<Credential> credentials = this.getEffectiveSigningCredentials(criteria);
        List<String> algorithms = this.getEffectiveSignatureAlgorithms(criteria, includeExcludePredicate);
        this.log.trace("Resolved effective signature algorithms: {}", algorithms);
        this.findCompatibleAlgorithmAndCredential(algorithms, credentials, params);
    }

    protected void findCompatibleAlgorithmAndCredential(@Nonnull List<String> algorithms, @Nonnull List<Credential> credentials, @Nonnull SignatureSigningParameters params) {
        for (String algorithm : algorithms) {
            assert (algorithm != null);
            for (Credential credential : credentials) {
                assert (credential != null);
                if (this.log.isTraceEnabled()) {
                    Key key = CredentialSupport.extractSigningKey((Credential)credential);
                    this.log.trace("Evaluating signing credential '{}' of type '{}' against algorithm: {}", new Object[]{CredentialConversionUtil.resolveKid((Credential)credential), key != null ? key.getAlgorithm() : "n/a", algorithm});
                }
                if (this.credentialSupportsSigningAlgorithm(credential, algorithm)) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("Credential '{}' passed eval against algorithm: {}", (Object)CredentialConversionUtil.resolveKid((Credential)credential), (Object)algorithm);
                    }
                    params.setSigningCredential(credential);
                    params.setSignatureAlgorithm(algorithm);
                    return;
                }
                if (!this.log.isTraceEnabled()) continue;
                this.log.trace("Credential '{}' failed eval against algorithm: {}", (Object)CredentialConversionUtil.resolveKid((Credential)credential), (Object)algorithm);
            }
        }
    }

    @Nonnull
    protected Predicate<String> getAlgorithmRuntimeSupportedPredicate() {
        return new AlgorithmRuntimeSupportedPredicate(this.getAlgorithmRegistry());
    }

    protected boolean credentialSupportsSigningAlgorithm(@Nonnull Credential credential, @Nonnull @NotEmpty String algorithm) {
        try {
            JWSAlgorithm supportedAlgorithm = JWSAlgorithm.parse((String)algorithm);
            assert (supportedAlgorithm != null);
            Key key = CredentialSupport.extractSigningKey((Credential)credential);
            if (key == null) {
                return false;
            }
            boolean credSupportsAlgorithm = false;
            SecretKey secretKey = credential.getSecretKey();
            PrivateKey privateKey = credential.getPrivateKey();
            if (JWSAlgorithm.Family.HMAC_SHA.contains((Object)supportedAlgorithm) && secretKey != null && JWACredentialSupport.keyLengthSupportsMACAlgorithm((JWSAlgorithm)supportedAlgorithm, (Key)secretKey)) {
                credSupportsAlgorithm = true;
            } else if (JWSAlgorithm.Family.RSA.contains((Object)supportedAlgorithm) && credential.getPrivateKey() instanceof RSAPrivateKey) {
                credSupportsAlgorithm = true;
            } else if (JWSAlgorithm.Family.EC.contains((Object)supportedAlgorithm) && privateKey instanceof ECPrivateKey && JWACredentialSupport.keySupportsCurve((ECKey)((ECKey)((Object)privateKey)), (JWSAlgorithm)supportedAlgorithm)) {
                credSupportsAlgorithm = true;
            }
            AlgorithmDescriptor algorithmDescriptor = this.getAlgorithmRegistry().get(algorithm);
            if (algorithmDescriptor == null) {
                return credSupportsAlgorithm;
            }
            return credSupportsAlgorithm && AlgorithmSupport.checkKeyAlgorithmAndLength((Key)key, (AlgorithmDescriptor)algorithmDescriptor);
        }
        catch (JOSEException e) {
            this.log.trace("Algorithm '{}' and EC credential '{}' threw an error while checking for compatibility, credential can not be used", new Object[]{algorithm, CredentialConversionUtil.resolveKid((Credential)credential), e});
            return false;
        }
    }

    @Nonnull
    protected List<Credential> getEffectiveSigningCredentials(@Nonnull CriteriaSet criteria) {
        SignatureSigningConfigurationCriterion signingCrit = (SignatureSigningConfigurationCriterion)criteria.get(SignatureSigningConfigurationCriterion.class);
        assert (signingCrit != null);
        ArrayList<Credential> accumulator = new ArrayList<Credential>();
        for (SignatureSigningConfiguration config : signingCrit.getConfigurations()) {
            accumulator.addAll(config.getSigningCredentials());
        }
        return accumulator;
    }

    @Nonnull
    protected List<String> getEffectiveSignatureAlgorithms(@Nonnull CriteriaSet criteria, @Nonnull Predicate<String> includeExcludePredicate) {
        SignatureSigningConfigurationCriterion signingCrit = (SignatureSigningConfigurationCriterion)criteria.get(SignatureSigningConfigurationCriterion.class);
        assert (signingCrit != null);
        ArrayList<String> accumulator = new ArrayList<String>();
        for (SignatureSigningConfiguration config : signingCrit.getConfigurations()) {
            config.getSignatureAlgorithms().stream().filter(PredicateSupport.and(this.getAlgorithmRuntimeSupportedPredicate(), includeExcludePredicate)).forEach(accumulator::add);
        }
        return accumulator;
    }
}

