/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.jose.impl;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.security.jose.EncryptionConfiguration;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.xmlsec.impl.BasicAlgorithmPolicyConfiguration;

public class BasicEncryptionConfiguration
extends BasicAlgorithmPolicyConfiguration
implements EncryptionConfiguration {
    @Nonnull
    @NonnullElements
    private List<String> dataEncryptionAlgorithms = CollectionSupport.emptyList();
    @Nonnull
    @NonnullElements
    private List<String> keyTransportEncryptionAlgorithms = CollectionSupport.emptyList();
    @Nullable
    private CredentialResolver kekKeyCredentialResolver;
    @Nullable
    private CredentialResolver contentEncryptionKeyCredentialResolver;

    @Nullable
    public CredentialResolver getContentEncryptionKeyCredentialResolver() {
        return this.contentEncryptionKeyCredentialResolver;
    }

    public void setContentEncryptionKeyCredentialResolver(@Nullable CredentialResolver resolver) {
        this.contentEncryptionKeyCredentialResolver = resolver;
    }

    @Nullable
    public CredentialResolver getKEKCredentialResolver() {
        return this.kekKeyCredentialResolver;
    }

    public void setKEKCredentialResolver(@Nullable CredentialResolver resolver) {
        this.kekKeyCredentialResolver = resolver;
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    public List<String> getDataEncryptionAlgorithms() {
        return this.dataEncryptionAlgorithms;
    }

    public void setDataEncryptionAlgorithms(@Nullable @NonnullElements List<String> algorithms) {
        this.dataEncryptionAlgorithms = algorithms == null ? CollectionSupport.emptyList() : CollectionSupport.copyToList((Collection)StringSupport.normalizeStringCollection(algorithms));
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    public List<String> getKeyTransportEncryptionAlgorithms() {
        return this.keyTransportEncryptionAlgorithms;
    }

    public void setKeyTransportEncryptionAlgorithms(@Nullable @NonnullElements List<String> algorithms) {
        this.keyTransportEncryptionAlgorithms = algorithms == null ? CollectionSupport.emptyList() : CollectionSupport.copyToList((Collection)StringSupport.normalizeStringCollection(algorithms));
    }
}

