/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.impl;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.text.ParseException;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.security.impl.JWSTokenSigner;
import net.shibboleth.oidc.security.jose.SignatureException;
import net.shibboleth.oidc.security.jose.SignatureSigningParameters;
import net.shibboleth.oidc.security.jose.context.SecurityParametersContext;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.slf4j.Logger;

public class SignJWTHandler
extends AbstractMessageHandler {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SignJWTHandler.class);
    @Nonnull
    private Function<MessageContext, SecurityParametersContext> securityParametersLookupStrategy = new ChildContextLookup(SecurityParametersContext.class);
    @NonnullAfterInit
    private BiConsumer<JWT, MessageContext> jwtUpdateConsumer;
    @NonnullAfterInit
    private Function<MessageContext, JWTClaimsSet> claimsToSignLookupStrategy;
    @NonnullBeforeExec
    private JWTClaimsSet jwtClaimSetToSign;
    @Nonnull
    private Function<MessageContext, String> typeHeaderLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    @NotEmpty
    private String logName = "not-specified";
    @NonnullBeforeExec
    private JWSTokenSigner signer;

    public void setLogName(@Nonnull @NotEmpty String name) {
        this.checkSetterPreconditions();
        this.logName = Constraint.isNotEmpty((String)name, (String)"ForFriendlyName can not be null or empty");
    }

    protected void doInitialize() throws ComponentInitializationException {
        if (this.claimsToSignLookupStrategy == null) {
            throw new ComponentInitializationException("Claims To Sign Lookup Strategy can not be null");
        }
        if (this.jwtUpdateConsumer == null) {
            throw new ComponentInitializationException("JWT Update Consumer can not be null");
        }
        super.doInitialize();
    }

    public void setClaimsToSignLookupStrategy(@Nonnull Function<MessageContext, JWTClaimsSet> strategy) {
        this.checkSetterPreconditions();
        this.claimsToSignLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Claims To Sign Lookup Strategy can not be null");
    }

    public void setJwtUpdateConsumer(BiConsumer<JWT, MessageContext> consumer) {
        this.checkSetterPreconditions();
        this.jwtUpdateConsumer = (BiConsumer)Constraint.isNotNull(consumer, (String)"JWT Update Consumer can not be null");
    }

    public void setTypeHeader(@Nullable @NotEmpty String type) {
        this.checkSetterPreconditions();
        this.typeHeaderLookupStrategy = FunctionSupport.constant((Object)StringSupport.trimOrNull((String)type));
    }

    public void setSecurityParametersLookupStrategy(@Nonnull Function<MessageContext, SecurityParametersContext> strategy) {
        this.checkSetterPreconditions();
        this.securityParametersLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SecurityParameterContext lookup strategy cannot be null");
    }

    public void setTypeHeaderLookupStrategy(@Nonnull Function<MessageContext, String> strategy) {
        this.checkSetterPreconditions();
        this.typeHeaderLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Type header lookup strategy cannot be null");
    }

    protected boolean doPreInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        if (!super.doPreInvoke(messageContext)) {
            return false;
        }
        SecurityParametersContext secParamCtx = this.securityParametersLookupStrategy.apply(messageContext);
        if (secParamCtx == null) {
            this.log.debug("{} Message context did not contain a signing parameters context, signing skipped", (Object)this.getLogPrefix());
            return false;
        }
        SignatureSigningParameters signatureSigningParameters = secParamCtx.getSignatureSigningParameters();
        if (signatureSigningParameters == null) {
            this.log.debug("{} No signature signing parameters available, signing skipped", (Object)this.getLogPrefix());
            return false;
        }
        this.jwtClaimSetToSign = this.claimsToSignLookupStrategy.apply(messageContext);
        if (this.jwtClaimSetToSign == null) {
            this.log.debug("{} No JWT claims, nothing to sign", (Object)this.getLogPrefix());
            return false;
        }
        this.signer = new JWSTokenSigner(signatureSigningParameters);
        return true;
    }

    protected void doInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        String typeHeader = this.typeHeaderLookupStrategy.apply(messageContext);
        try {
            assert (this.jwtClaimSetToSign != null);
            SignedJWT signedJWT = this.signer.sign(this.jwtClaimSetToSign, typeHeader);
            this.log.debug("{} '{}' signed successfully", (Object)this.getLogPrefix(), (Object)this.logName);
            if (this.log.isTraceEnabled()) {
                this.logJWT(signedJWT);
            }
            this.jwtUpdateConsumer.accept((JWT)signedJWT, messageContext);
        }
        catch (SignatureException e) {
            this.log.error("{} Error signing '{}' : {}", new Object[]{this.getLogPrefix(), this.logName, e.getMessage()});
            throw new MessageHandlerException("Error signing token", (Exception)((Object)e));
        }
    }

    private void logJWT(@Nonnull SignedJWT jwt) {
        try {
            this.log.trace("{} Signed JWT: {}, signature '{}'", new Object[]{this.getLogPrefix(), jwt.getJWTClaimsSet(), jwt.getSignature()});
        }
        catch (IllegalStateException | ParseException e) {
            this.log.trace("{} Unable to print signed JWT: {}", (Object)this.getLogPrefix(), (Object)e.getMessage());
        }
    }
}

