/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.impl;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.ECDSAVerifier;
import com.nimbusds.jose.crypto.MACVerifier;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jwt.SignedJWT;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.security.credential.JWKCredential;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.security.credential.Credential;
import org.slf4j.Logger;

public final class JWTSignatureValidationUtil {
    @Nonnull
    private static Logger log = LoggerFactory.getLogger(JWTSignatureValidationUtil.class);

    private JWTSignatureValidationUtil() {
    }

    public static String validateSignatureEx(@Nonnull Collection<? extends Credential> credentials, @Nonnull SignedJWT signedJwt, @Nullable String invalidJwtEventId) {
        JWSAlgorithm algorithm = signedJwt.getHeader().getAlgorithm();
        for (Credential credential : credentials) {
            String kid;
            JWKCredential jwk;
            if (credential instanceof JWKCredential && (jwk = (JWKCredential)credential).getAlgorithm() != null && !algorithm.equals((Object)jwk.getAlgorithm())) {
                log.debug("Credential alg {} not matching jwt header alg {}", (Object)jwk.getAlgorithm(), (Object)algorithm.getName());
                continue;
            }
            try {
                JWSVerifier verifier = JWTSignatureValidationUtil.initializeVerifier((Algorithm)algorithm, credential);
                if (verifier == null) {
                    log.debug("No verifier for given JWT and Credential pair for alg {}", (Object)algorithm.getName());
                    continue;
                }
                if (signedJwt.verify(verifier)) {
                    if (log.isDebugEnabled()) {
                        kid = credential instanceof JWKCredential ? ((JWKCredential)credential).getKid() : null;
                        log.debug("JWT {} verified using algorithm {}{}", new Object[]{signedJwt.serialize(), algorithm.getName(), kid != null ? " and key " + kid : ""});
                    }
                    return null;
                }
                log.debug("Unable to validate given JWT with credential");
            }
            catch (JOSEException | IllegalStateException e) {
                kid = credential instanceof JWKCredential ? ((JWKCredential)credential).getKid() : null;
                log.warn("Exception caught when validating given JWT{}", kid != null ? " with credential " + kid : "", (Object)e);
            }
        }
        log.warn("Unable to validate given JWT with any of the credentials");
        return invalidJwtEventId;
    }

    @Nullable
    private static JWSVerifier initializeVerifier(@Nonnull Algorithm algorithm, @Nonnull Credential credential) throws JOSEException {
        if (JWSAlgorithm.Family.HMAC_SHA.contains((Object)algorithm) && credential.getSecretKey() != null) {
            return new MACVerifier(credential.getSecretKey());
        }
        if (JWSAlgorithm.Family.RSA.contains((Object)algorithm) && credential.getPublicKey() instanceof RSAPublicKey) {
            return new RSASSAVerifier((RSAPublicKey)credential.getPublicKey());
        }
        if (JWSAlgorithm.Family.EC.contains((Object)algorithm) && credential.getPublicKey() instanceof ECPublicKey) {
            return new ECDSAVerifier((ECPublicKey)credential.getPublicKey());
        }
        return null;
    }
}

